/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elx.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.xbib.elx.common.util.NetworkUtils;
import org.xbib.elx.transport.TransportAdminClient;

public class TransportClientHelper {
    private static final Logger logger = LogManager.getLogger((String)TransportAdminClient.class.getName());

    protected ElasticsearchClient createClient(Settings settings) {
        if (settings != null) {
            String systemIdentifier = System.getProperty("os.name") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.version") + " Elasticsearch " + Version.CURRENT.toString();
            Settings effectiveSettings = Settings.builder().put("processors", settings.getAsInt("processors", Integer.valueOf(Runtime.getRuntime().availableProcessors())).intValue()).put("client.transport.sniff", false).put("client.transport.nodes_sampler_interval", "1m").put("client.transport.ping_timeout", "1m").put("client.transport.ignore_cluster_name", true).put(settings).build();
            logger.info("creating transport client on {} with custom settings {} and effective settings {}", (Object)systemIdentifier, (Object)settings.getAsMap(), (Object)effectiveSettings.getAsMap());
            DefaultChannelFuture.setUseDeadLockChecker((boolean)false);
            return TransportClient.builder().settings(effectiveSettings).build();
        }
        return null;
    }

    public void init(TransportClient transportClient, Settings settings) throws IOException {
        Collection<TransportAddress> addrs = this.findAddresses(settings);
        if (!this.connect(transportClient, addrs, settings.getAsBoolean("autodiscover", Boolean.valueOf(false)))) {
            throw new NoNodeAvailableException("no cluster nodes available, check settings " + settings.toString());
        }
    }

    private Collection<TransportAddress> findAddresses(Settings settings) throws IOException {
        int defaultPort = settings.getAsInt("port", Integer.valueOf(9300));
        ArrayList<TransportAddress> addresses = new ArrayList<TransportAddress>();
        for (String hostname : settings.getAsArray("host")) {
            InetAddress inetAddress;
            String host;
            String[] splitHost = hostname.split(":", 2);
            if (splitHost.length == 2) {
                try {
                    host = splitHost[0];
                    inetAddress = NetworkUtils.resolveInetAddress((String)host, null);
                    int port = Integer.parseInt(splitHost[1]);
                    InetSocketTransportAddress address = new InetSocketTransportAddress(inetAddress, port);
                    addresses.add((TransportAddress)address);
                }
                catch (NumberFormatException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
            if (splitHost.length != 1) continue;
            host = splitHost[0];
            inetAddress = NetworkUtils.resolveInetAddress((String)host, null);
            InetSocketTransportAddress address = new InetSocketTransportAddress(inetAddress, defaultPort);
            addresses.add((TransportAddress)address);
        }
        return addresses;
    }

    private boolean connect(TransportClient transportClient, Collection<TransportAddress> addresses, boolean autodiscover) {
        for (TransportAddress address : addresses) {
            transportClient.addTransportAddresses(new TransportAddress[]{address});
        }
        List nodes = transportClient.connectedNodes();
        logger.info("connected to nodes = {}", (Object)nodes);
        if (nodes != null && !nodes.isEmpty()) {
            if (autodiscover) {
                logger.debug("trying to auto-discover all nodes...");
                ClusterStateRequestBuilder clusterStateRequestBuilder = new ClusterStateRequestBuilder((ElasticsearchClient)transportClient, ClusterStateAction.INSTANCE);
                ClusterStateResponse clusterStateResponse = (ClusterStateResponse)clusterStateRequestBuilder.execute().actionGet();
                DiscoveryNodes discoveryNodes = clusterStateResponse.getState().getNodes();
                this.addDiscoveryNodes(transportClient, discoveryNodes);
                logger.info("after auto-discovery: connected to {}", (Object)transportClient.connectedNodes());
            }
            return true;
        }
        return false;
    }

    private void addDiscoveryNodes(TransportClient transportClient, DiscoveryNodes discoveryNodes) {
        for (DiscoveryNode discoveryNode : discoveryNodes) {
            transportClient.addTransportAddress(discoveryNode.getAddress());
        }
    }
}

