package org.xbib.helianthus.client;

import org.xbib.helianthus.common.TimeoutException;
import org.xbib.helianthus.common.util.Exceptions;

/**
 * A {@link TimeoutException} raised when a response has not been received from a server within timeout.
 */
public final class ResponseTimeoutException extends TimeoutException {

    private static final long serialVersionUID = 2556616197251937869L;

    private static final ResponseTimeoutException INSTANCE =
            Exceptions.clearTrace(new ResponseTimeoutException());

    /**
     * Creates a new instance.
     */
    private ResponseTimeoutException() {
    }

    public static ResponseTimeoutException get() {
        return Exceptions.isVerbose() ? new ResponseTimeoutException() : INSTANCE;
    }
}
