package org.xbib.helianthus.client.http;

import io.netty.channel.EventLoop;
import org.xbib.helianthus.client.Client;
import org.xbib.helianthus.client.ClientBuilderParams;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.client.UserClient;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.AggregatedHttpMessage;
import org.xbib.helianthus.common.http.DefaultHttpRequest;
import org.xbib.helianthus.common.http.DefaultHttpResponse;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaderNames;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpRequest;
import org.xbib.helianthus.common.http.HttpResponse;

/**
 *
 */
final class DefaultHttpClient extends UserClient<HttpRequest, HttpResponse> implements HttpClient {

    DefaultHttpClient(ClientBuilderParams params,
                      Client<HttpRequest, HttpResponse> delegate,
                      SessionProtocol sessionProtocol, Endpoint endpoint) {
        super(params, delegate, sessionProtocol, endpoint);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        return execute(eventLoop(), req);
    }

    private HttpResponse execute(EventLoop eventLoop, HttpRequest req) {
        return execute(eventLoop, req.method().name(), req.path(), "", req, cause -> {
            final DefaultHttpResponse res = new DefaultHttpResponse();
            res.close(cause);
            return res;
        });
    }

    @Override
    public HttpResponse execute(AggregatedHttpMessage aggregatedReq) {
        return execute(eventLoop(), aggregatedReq);
    }

    private HttpResponse execute(EventLoop eventLoop, AggregatedHttpMessage aggregatedReq) {
        final HttpHeaders headers = aggregatedReq.headers();
        final DefaultHttpRequest req = new DefaultHttpRequest(headers);
        final HttpData content = aggregatedReq.content();
        // Add content if not empty.
        if (!content.isEmpty()) {
            headers.setInt(HttpHeaderNames.CONTENT_LENGTH, content.length());
            req.write(content);
        }
        // Add trailing headers if not empty.
        final HttpHeaders trailingHeaders = aggregatedReq.trailingHeaders();
        if (!trailingHeaders.isEmpty()) {
            req.write(trailingHeaders);
        }
        req.close();
        return execute(eventLoop, req);
    }

    public static HttpClient newInstance(ClientBuilderParams params,
                                     Client<HttpRequest, HttpResponse> delegate,
                                     SessionProtocol sessionProtocol, Endpoint endpoint) {
        return new DefaultHttpClient(params, delegate, sessionProtocol, endpoint);
    }
}
