/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.xbib.helianthus.client.ClientDecoration;
import org.xbib.helianthus.client.ClientOption;
import org.xbib.helianthus.client.ClientOptionValue;
import org.xbib.helianthus.common.http.DefaultHttpHeaders;
import org.xbib.helianthus.common.http.HttpHeaderNames;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.util.AbstractOptionValue;
import org.xbib.helianthus.common.util.AbstractOptions;

public final class ClientOptions
extends AbstractOptions {
    private static final Long DEFAULT_DEFAULT_WRITE_TIMEOUT_MILLIS = Duration.ofSeconds(1L).toMillis();
    private static final Long DEFAULT_DEFAULT_RESPONSE_TIMEOUT_MILLIS = Duration.ofSeconds(10L).toMillis();
    private static final Long DEFAULT_DEFAULT_MAX_RESPONSE_LENGTH = 0xA00000L;
    private static final Collection<AsciiString> BLACKLISTED_HEADER_NAMES = Collections.unmodifiableCollection(Arrays.asList(HttpHeaderNames.AUTHORITY, HttpHeaderNames.CONNECTION, HttpHeaderNames.HOST, HttpHeaderNames.KEEP_ALIVE, HttpHeaderNames.METHOD, HttpHeaderNames.PATH, HttpHeaderNames.PROXY_CONNECTION, HttpHeaderNames.SCHEME, HttpHeaderNames.STATUS, HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderNames.UPGRADE, HttpHeaderNames.USER_AGENT, HttpConversionUtil.ExtensionHeaderNames.PATH.text(), HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text()));
    private static final ClientOptionValue<?>[] DEFAULT_OPTIONS = new ClientOptionValue[]{ClientOption.DEFAULT_WRITE_TIMEOUT_MILLIS.newValue(DEFAULT_DEFAULT_WRITE_TIMEOUT_MILLIS), ClientOption.DEFAULT_RESPONSE_TIMEOUT_MILLIS.newValue(DEFAULT_DEFAULT_RESPONSE_TIMEOUT_MILLIS), ClientOption.DEFAULT_MAX_RESPONSE_LENGTH.newValue(DEFAULT_DEFAULT_MAX_RESPONSE_LENGTH), ClientOption.DECORATION.newValue(ClientDecoration.NONE), ClientOption.HTTP_HEADERS.newValue(HttpHeaders.EMPTY_HEADERS)};
    public static final ClientOptions DEFAULT = new ClientOptions(DEFAULT_OPTIONS);

    private ClientOptions(ClientOptionValue<?> ... options) {
        super(ClientOptions::filterValue, (AbstractOptionValue[])options);
    }

    private ClientOptions(ClientOptions clientOptions, ClientOptionValue<?> ... options) {
        super(ClientOptions::filterValue, (AbstractOptions)clientOptions, (AbstractOptionValue[])options);
    }

    private ClientOptions(ClientOptions clientOptions, Iterable<ClientOptionValue<?>> options) {
        super(ClientOptions::filterValue, (AbstractOptions)clientOptions, options);
    }

    private ClientOptions(ClientOptions clientOptions, ClientOptions options) {
        super((AbstractOptions)clientOptions, (AbstractOptions)options);
    }

    public static ClientOptions of(ClientOptionValue<?> ... options) {
        Objects.requireNonNull(options, "options");
        if (options.length == 0) {
            return DEFAULT;
        }
        return new ClientOptions(DEFAULT, options);
    }

    public static ClientOptions of(Iterable<ClientOptionValue<?>> options) {
        return new ClientOptions(DEFAULT, options);
    }

    public static ClientOptions of(ClientOptions baseOptions, ClientOptionValue<?> ... options) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(options, "options");
        if (options.length == 0) {
            return baseOptions;
        }
        return new ClientOptions(baseOptions, options);
    }

    public static ClientOptions of(ClientOptions baseOptions, Iterable<ClientOptionValue<?>> options) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(options, "options");
        return new ClientOptions(baseOptions, options);
    }

    public static ClientOptions of(ClientOptions baseOptions, ClientOptions options) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(options, "options");
        return new ClientOptions(baseOptions, options);
    }

    private static <T> ClientOptionValue<T> filterValue(ClientOptionValue<T> optionValue) {
        Objects.requireNonNull(optionValue, "optionValue");
        ClientOption option = (ClientOption)optionValue.option();
        Object value = optionValue.value();
        if (option == ClientOption.HTTP_HEADERS) {
            ClientOption castOption = option;
            ClientOptionValue<HttpHeaders> castOptionValue = castOption.newValue(ClientOptions.filterHttpHeaders((HttpHeaders)value));
            optionValue = castOptionValue;
        }
        return optionValue;
    }

    private static HttpHeaders filterHttpHeaders(HttpHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        for (AsciiString name : BLACKLISTED_HEADER_NAMES) {
            if (!headers.contains((Object)name)) continue;
            throw new IllegalArgumentException("unallowed header name: " + name);
        }
        return ((HttpHeaders)new DefaultHttpHeaders().add((Headers)headers)).asImmutable();
    }

    public <T> Optional<T> get(ClientOption<T> option) {
        return this.get0(option);
    }

    public <T> T getOrElse(ClientOption<T> option, T defaultValue) {
        return (T)this.getOrElse0(option, defaultValue);
    }

    public Map<ClientOption<Object>, ClientOptionValue<Object>> asMap() {
        return this.asMap0();
    }

    public long defaultResponseTimeoutMillis() {
        return this.getOrElse(ClientOption.DEFAULT_RESPONSE_TIMEOUT_MILLIS, DEFAULT_DEFAULT_RESPONSE_TIMEOUT_MILLIS);
    }

    public long defaultWriteTimeoutMillis() {
        return this.getOrElse(ClientOption.DEFAULT_WRITE_TIMEOUT_MILLIS, DEFAULT_DEFAULT_WRITE_TIMEOUT_MILLIS);
    }

    public long defaultMaxResponseLength() {
        return this.getOrElse(ClientOption.DEFAULT_MAX_RESPONSE_LENGTH, DEFAULT_DEFAULT_MAX_RESPONSE_LENGTH);
    }

    public ClientDecoration decoration() {
        return this.getOrElse(ClientOption.DECORATION, ClientDecoration.NONE);
    }
}

