/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import java.util.Objects;
import java.util.Optional;
import org.xbib.helianthus.common.SessionProtocol;

public final class SessionProtocolNegotiationException
extends RuntimeException {
    private static final long serialVersionUID = 5788454584691399858L;
    private final SessionProtocol expected;
    private final SessionProtocol actual;

    public SessionProtocolNegotiationException(SessionProtocol expected, String reason) {
        super("expected: " + Objects.requireNonNull(expected, "expected") + ", reason: " + reason);
        this.expected = expected;
        this.actual = null;
    }

    public SessionProtocolNegotiationException(SessionProtocol expected, SessionProtocol actual, String reason) {
        super("expected: " + Objects.requireNonNull(expected, "expected") + ", actual: " + Objects.requireNonNull(actual, "actual") + ", reason: " + reason);
        this.expected = expected;
        this.actual = actual;
    }

    public SessionProtocol expected() {
        return this.expected;
    }

    public Optional<SessionProtocol> actual() {
        return Optional.ofNullable(this.actual);
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }
}

