/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import java.net.URI;
import java.util.function.Function;
import org.xbib.helianthus.client.Client;
import org.xbib.helianthus.client.ClientBuilderParams;
import org.xbib.helianthus.client.ClientFactory;
import org.xbib.helianthus.client.ClientOptions;
import org.xbib.helianthus.client.ClientRequestContext;
import org.xbib.helianthus.client.DefaultClientRequestContext;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.common.Request;
import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.Response;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.DefaultHttpHeaders;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.util.SafeCloseable;

public abstract class UserClient<I extends Request, O extends Response>
implements ClientBuilderParams {
    private static final ThreadLocal<Function<HttpHeaders, HttpHeaders>> THREAD_LOCAL_HEADER_MANIPULATOR = new ThreadLocal();
    private final ClientBuilderParams params;
    private final Client<I, O> delegate;
    private final SessionProtocol sessionProtocol;
    private final Endpoint endpoint;

    protected UserClient(ClientBuilderParams params, Client<I, O> delegate, SessionProtocol sessionProtocol, Endpoint endpoint) {
        this.params = params;
        this.delegate = delegate;
        this.sessionProtocol = sessionProtocol;
        this.endpoint = endpoint;
    }

    @Override
    public ClientFactory factory() {
        return this.params.factory();
    }

    @Override
    public URI uri() {
        return this.params.uri();
    }

    @Override
    public Class<?> clientType() {
        return this.params.clientType();
    }

    @Override
    public final ClientOptions options() {
        return this.params.options();
    }

    protected final EventLoop eventLoop() {
        return this.params.factory().eventLoopSupplier().get();
    }

    protected final <U extends Client<I, O>> U delegate() {
        return (U)this.delegate;
    }

    protected final SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    protected final Endpoint endpoint() {
        return this.endpoint;
    }

    protected final O execute(String method, String path, String fragment, I req, Function<Throwable, O> fallback) {
        return this.execute(this.eventLoop(), method, path, fragment, req, fallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final O execute(EventLoop eventLoop, String method, String path, String fragment, I req, Function<Throwable, O> fallback) {
        DefaultClientRequestContext ctx = new DefaultClientRequestContext(eventLoop, this.sessionProtocol, this.endpoint, method, path, fragment, this.options(), req);
        try (SafeCloseable ignored = RequestContext.push((RequestContext)ctx);){
            UserClient.runThreadLocalHeaderManipulator(ctx);
            Object o = this.delegate().execute(ctx, req);
            return o;
        }
        catch (Throwable cause) {
            ctx.logBuilder().endResponse(cause);
            return (O)((Response)fallback.apply(cause));
        }
    }

    private static void runThreadLocalHeaderManipulator(ClientRequestContext ctx) {
        Attribute attr;
        Function<HttpHeaders, HttpHeaders> manipulator = THREAD_LOCAL_HEADER_MANIPULATOR.get();
        if (manipulator == null) {
            return;
        }
        HttpHeaders headers = (HttpHeaders)(attr = ctx.attr(ClientRequestContext.HTTP_HEADERS)).get();
        attr.set((Object)manipulator.apply((HttpHeaders)(headers != null ? headers : new DefaultHttpHeaders())));
    }
}

