/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.bootstrap.Bootstrap;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.xbib.helianthus.client.Client;
import org.xbib.helianthus.client.ClientBuilderParams;
import org.xbib.helianthus.client.ClientOptions;
import org.xbib.helianthus.client.DefaultClientBuilderParams;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.client.NonDecoratingClientFactory;
import org.xbib.helianthus.client.SessionOptions;
import org.xbib.helianthus.client.http.DefaultHttpClient;
import org.xbib.helianthus.client.http.HttpClient;
import org.xbib.helianthus.client.http.HttpClientDelegate;
import org.xbib.helianthus.common.Scheme;
import org.xbib.helianthus.common.SerializationFormat;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.HttpRequest;
import org.xbib.helianthus.common.http.HttpResponse;

public class HttpClientFactory
extends NonDecoratingClientFactory {
    private static final Set<Scheme> SUPPORTED_SCHEMES;
    private final HttpClientDelegate delegate = new HttpClientDelegate(this);

    public HttpClientFactory() {
        this(SessionOptions.DEFAULT, false);
    }

    public HttpClientFactory(SessionOptions options) {
        this(options, false);
    }

    public HttpClientFactory(SessionOptions options, boolean useDaemonThreads) {
        super(options, useDaemonThreads);
    }

    @Override
    public Set<Scheme> supportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    @Override
    public Bootstrap newBootstrap() {
        return super.newBootstrap();
    }

    @Override
    public <T> T newClient(URI uri, Class<T> clientType, ClientOptions options) {
        DefaultHttpClient client;
        Scheme scheme = this.validate(uri, clientType, options);
        HttpClientFactory.validateClientType(clientType);
        Client<HttpRequest, HttpResponse> delegate = options.decoration().decorate(HttpRequest.class, HttpResponse.class, new HttpClientDelegate(this));
        if (clientType == Client.class) {
            Client<HttpRequest, HttpResponse> castClient = delegate;
            return (T)castClient;
        }
        Endpoint endpoint = HttpClientFactory.newEndpoint(uri);
        DefaultHttpClient castClient = client = this.newHttpClient(uri, scheme, endpoint, options, delegate);
        return (T)castClient;
    }

    private DefaultHttpClient newHttpClient(URI uri, Scheme scheme, Endpoint endpoint, ClientOptions options, Client<HttpRequest, HttpResponse> delegate) {
        return new DefaultHttpClient((ClientBuilderParams)new DefaultClientBuilderParams(this, uri, HttpClient.class, options), delegate, scheme.sessionProtocol(), endpoint);
    }

    private static void validateClientType(Class<?> clientType) {
        if (clientType != HttpClient.class && clientType != Client.class) {
            throw new IllegalArgumentException("clientType: " + clientType + " (expected: " + HttpClient.class.getSimpleName() + ", " + Client.class.getSimpleName() + ')');
        }
    }

    @Override
    public void close() {
        this.delegate.close();
        super.close();
    }

    static {
        HashSet<Scheme> set = new HashSet<Scheme>();
        for (SessionProtocol p : SessionProtocol.ofHttp()) {
            set.add(Scheme.of((SerializationFormat)SerializationFormat.NONE, (SessionProtocol)p));
        }
        SUPPORTED_SCHEMES = set;
    }
}

