/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.logging.Logger;
import org.xbib.helianthus.client.ClientRequestContext;
import org.xbib.helianthus.client.http.DecodedHttpResponse;
import org.xbib.helianthus.common.ClosedSessionException;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.HttpRequest;
import org.xbib.helianthus.internal.InboundTrafficController;

interface HttpSession {
    public static final Logger logger = Logger.getLogger(HttpSession.class.getName());
    public static final HttpSession INACTIVE = new HttpSession(){
        private final InboundTrafficController inboundTrafficController = new InboundTrafficController(null, 0, 0);

        @Override
        public SessionProtocol protocol() {
            return null;
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public InboundTrafficController inboundTrafficController() {
            return this.inboundTrafficController;
        }

        @Override
        public boolean hasUnfinishedResponses() {
            return false;
        }

        @Override
        public boolean invoke(ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
            res.close((Throwable)ClosedSessionException.get());
            return false;
        }

        @Override
        public void retryWithH1C() {
            throw new IllegalStateException();
        }

        @Override
        public void deactivate() {
        }
    };

    public static HttpSession get(Channel ch) {
        ChannelHandler lastHandler = ch.pipeline().last();
        if (lastHandler instanceof HttpSession) {
            return (HttpSession)lastHandler;
        }
        for (ChannelHandler h : ch.pipeline().toMap().values()) {
            if (!(h instanceof HttpSession)) continue;
            return (HttpSession)h;
        }
        return INACTIVE;
    }

    public SessionProtocol protocol();

    public boolean isActive();

    public InboundTrafficController inboundTrafficController();

    public boolean hasUnfinishedResponses();

    public boolean invoke(ClientRequestContext var1, HttpRequest var2, DecodedHttpResponse var3);

    public void retryWithH1C();

    public void deactivate();
}

