package org.xbib.helianthus.client;

import static java.util.Objects.requireNonNull;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import org.xbib.helianthus.common.Scheme;

import java.net.URI;
import java.util.Set;
import java.util.function.Supplier;

public class DecoratingClientFactory extends AbstractClientFactory {

    private final ClientFactory delegate;

    protected DecoratingClientFactory(ClientFactory delegate) {
        this.delegate = requireNonNull(delegate, "delegate");
    }

    protected ClientFactory delegate() {
        return delegate;
    }

    @Override
    public Set<Scheme> supportedSchemes() {
        return delegate().supportedSchemes();
    }

    @Override
    public SessionOptions options() {
        return delegate().options();
    }

    @Override
    public EventLoopGroup eventLoopGroup() {
        return delegate().eventLoopGroup();
    }

    @Override
    public Supplier<EventLoop> eventLoopSupplier() {
        return delegate().eventLoopSupplier();
    }

    @Override
    public <T> T newClient(URI uri, Class<T> clientType, ClientOptions options) {
        return delegate().newClient(uri, clientType, options);
    }

    @Override
    public void close() {
        delegate().close();
    }
}
