package org.xbib.helianthus.client.http;

import io.netty.channel.EventLoop;
import org.reactivestreams.Subscriber;
import org.xbib.helianthus.common.http.DefaultHttpResponse;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.internal.InboundTrafficController;

/**
 *
 */
final class DecodedHttpResponse extends DefaultHttpResponse {

    private final EventLoop eventLoop;

    private InboundTrafficController inboundTrafficController;

    private long writtenBytes;

    DecodedHttpResponse(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    void init(InboundTrafficController inboundTrafficController) {
        this.inboundTrafficController = inboundTrafficController;
    }

    long writtenBytes() {
        return writtenBytes;
    }

    @Override
    public void subscribe(Subscriber<? super HttpObject> subscriber) {
        subscribe(subscriber, eventLoop);
    }

    @Override
    public boolean write(HttpObject obj) {
        final boolean published = super.write(obj);
        if (published && obj instanceof HttpData) {
            final int length = ((HttpData) obj).length();
            inboundTrafficController.inc(length);
            writtenBytes += length;
        }
        return published;
    }

    @Override
    protected void onRemoval(HttpObject obj) {
        if (obj instanceof HttpData) {
            final int length = ((HttpData) obj).length();
            inboundTrafficController.dec(length);
        }
    }
}
