package org.xbib.helianthus.client.pool;

import io.netty.channel.Channel;

/**
 * A skeletal {@link KeyedChannelPoolHandler} implementation to minimize the effort to implement this interface.
 * Extend this class to implement only few of the provided handler methods.
 */
public class KeyedChannelPoolHandlerAdapter<K> implements KeyedChannelPoolHandler<K> {

    @Override
    public void channelReleased(K key, Channel ch) throws Exception {
    }

    @Override
    public void channelAcquired(K key, Channel ch) throws Exception {
    }

    @Override
    public void channelCreated(K key, Channel ch) throws Exception {
    }

    @Override
    public void channelClosed(K key, Channel ch) throws Exception {
    }
}
