/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.xbib.helianthus.client.Client;
import org.xbib.helianthus.client.ClientDecorationBuilder;
import org.xbib.helianthus.common.Request;
import org.xbib.helianthus.common.Response;

public final class ClientDecoration {
    public static final ClientDecoration NONE = new ClientDecoration(Collections.emptyList());
    private final List<Entry<?, ?>> entries;

    ClientDecoration(List<Entry<?, ?>> entries) {
        this.entries = Collections.unmodifiableList(entries);
    }

    public static <T extends Client<? super I, ? extends O>, R extends Client<I, O>, I extends Request, O extends Response> ClientDecoration of(Class<I> requestType, Class<O> responseType, Function<T, R> decorator) {
        return new ClientDecorationBuilder().add(requestType, responseType, decorator).build();
    }

    public <I extends Request, O extends Response> Client<I, O> decorate(Class<I> requestType, Class<O> responseType, Client<I, O> client) {
        for (Entry<?, ?> e : this.entries) {
            if (!requestType.isAssignableFrom(e.requestType()) || !responseType.isAssignableFrom(e.responseType())) continue;
            Function<Client<?, ?>, Client<?, ?>> decorator = e.decorator();
            client = decorator.apply(client);
        }
        return client;
    }

    static final class Entry<I extends Request, O extends Response> {
        private final Class<I> requestType;
        private final Class<O> responseType;
        private final Function<Client<? super I, ? extends O>, Client<I, O>> decorator;

        Entry(Class<I> requestType, Class<O> responseType, Function<? extends Client<? super I, ? extends O>, ? extends Client<I, O>> decorator) {
            this.requestType = requestType;
            this.responseType = responseType;
            Function<Client<I, O>, Client<I, O>> castDecorator = decorator;
            this.decorator = castDecorator;
        }

        public Class<I> requestType() {
            return this.requestType;
        }

        public Class<O> responseType() {
            return this.responseType;
        }

        public Function<Client<? super I, ? extends O>, Client<I, O>> decorator() {
            return this.decorator;
        }

        public String toString() {
            return '(' + this.requestType.getSimpleName() + ", " + this.responseType.getSimpleName() + ", " + this.decorator + ')';
        }
    }
}

