/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import java.net.URI;
import org.xbib.helianthus.client.ClientBuilder;
import org.xbib.helianthus.client.ClientFactory;
import org.xbib.helianthus.client.ClientOptionDerivable;
import org.xbib.helianthus.client.ClientOptionValue;
import org.xbib.helianthus.client.ClientOptions;

public final class Clients {
    private Clients() {
    }

    public static <T> T newClient(String uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        return Clients.newClient(ClientFactory.DEFAULT, uri, clientType, options);
    }

    public static <T> T newClient(String uri, Class<T> clientType, ClientOptions options) {
        return Clients.newClient(ClientFactory.DEFAULT, uri, clientType, options);
    }

    public static <T> T newClient(ClientFactory factory, String uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        return new ClientBuilder(uri).factory(factory).options(options).build(clientType);
    }

    public static <T> T newClient(ClientFactory factory, String uri, Class<T> clientType, ClientOptions options) {
        return new ClientBuilder(uri).factory(factory).options(options).build(clientType);
    }

    public static <T> T newClient(URI uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        return Clients.newClient(ClientFactory.DEFAULT, uri, clientType, options);
    }

    public static <T> T newClient(URI uri, Class<T> clientType, ClientOptions options) {
        return Clients.newClient(ClientFactory.DEFAULT, uri, clientType, options);
    }

    public static <T> T newClient(ClientFactory factory, URI uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        return new ClientBuilder(uri).factory(factory).options(options).build(clientType);
    }

    public static <T> T newClient(ClientFactory factory, URI uri, Class<T> clientType, ClientOptions options) {
        return new ClientBuilder(uri).factory(factory).options(options).build(clientType);
    }

    public static <T> T newDerivedClient(T client, ClientOptionValue<?> ... additionalOptions) {
        return Clients.asDerivable(client).withOptions(additionalOptions);
    }

    public static <T> T newDerivedClient(T client, Iterable<ClientOptionValue<?>> additionalOptions) {
        return Clients.asDerivable(client).withOptions(additionalOptions);
    }

    private static <T> ClientOptionDerivable<T> asDerivable(T client) {
        if (!(client instanceof ClientOptionDerivable)) {
            throw new IllegalArgumentException("client doesn't support derivation: " + client);
        }
        ClientOptionDerivable derivable = (ClientOptionDerivable)client;
        return derivable;
    }
}

