/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import java.util.Objects;
import org.xbib.helianthus.client.routing.EndpointGroupRegistry;

public final class Endpoint {
    private final String groupName;
    private final String host;
    private final int port;
    private final int weight;
    private String authority;

    private Endpoint(String groupName) {
        this.groupName = groupName;
        this.host = null;
        this.port = 0;
        this.weight = 0;
    }

    private Endpoint(String host, int port, int weight) {
        this.host = host;
        this.port = port;
        this.weight = weight;
        this.groupName = null;
    }

    public static Endpoint parse(String authority) {
        Objects.requireNonNull(authority, "authority");
        if (authority.startsWith("group:")) {
            return Endpoint.ofGroup(authority.substring(6));
        }
        String host = authority;
        int port = 0;
        int pos = authority.indexOf(":");
        if (pos >= 0) {
            host = authority.substring(0, pos);
            port = Integer.parseInt(authority.substring(pos + 1));
        }
        return new Endpoint(host, port, 1000);
    }

    public static Endpoint ofGroup(String name) {
        Objects.requireNonNull(name, "name");
        return new Endpoint(name);
    }

    public static Endpoint of(String host, int port) {
        return Endpoint.of(host, port, 1000);
    }

    public static Endpoint of(String host) {
        return new Endpoint(host, 0, 1000);
    }

    public static Endpoint of(String host, int port, int weight) {
        Objects.requireNonNull(host, "host");
        Endpoint.validatePort("port", port);
        if (weight <= 0) {
            throw new IllegalArgumentException("weight: " + weight + " (expected: > 0)");
        }
        return new Endpoint(host, port, weight);
    }

    private static void validatePort(String name, int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException(name + ": " + port + " (expected: 1-65535)");
        }
    }

    public boolean isGroup() {
        return this.groupName != null;
    }

    public Endpoint resolve() {
        if (this.isGroup()) {
            return EndpointGroupRegistry.selectNode(this.groupName);
        }
        return this;
    }

    public String groupName() {
        this.ensureGroup();
        return this.groupName;
    }

    public String host() {
        this.ensureSingle();
        return this.host;
    }

    public int port() {
        this.ensureSingle();
        if (this.port == 0) {
            throw new IllegalStateException("port not specified");
        }
        return this.port;
    }

    public int port(int defaultPort) {
        this.ensureSingle();
        Endpoint.validatePort("defaultPort", defaultPort);
        return this.port != 0 ? this.port : defaultPort;
    }

    public Endpoint withDefaultPort(int defaultPort) {
        this.ensureSingle();
        Endpoint.validatePort("defaultPort", defaultPort);
        return this.port != 0 ? this : new Endpoint(this.host(), defaultPort, this.weight());
    }

    public int weight() {
        this.ensureSingle();
        return this.weight;
    }

    public String authority() {
        String authority = this.authority;
        if (authority != null) {
            return authority;
        }
        authority = this.isGroup() ? "group:" + this.groupName : (this.port != 0 ? this.host() + ':' + this.port : this.host());
        this.authority = authority;
        return this.authority;
    }

    private void ensureGroup() {
        if (!this.isGroup()) {
            throw new IllegalStateException("not a group endpoint");
        }
    }

    private void ensureSingle() {
        if (this.isGroup()) {
            throw new IllegalStateException("not a host:port endpoint");
        }
    }

    public String toString() {
        return "Endpoint(" + this.authority() + ')';
    }
}

