/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.channel.EventLoop;
import java.util.concurrent.Executor;
import org.reactivestreams.Subscriber;
import org.xbib.helianthus.common.http.DefaultHttpResponse;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.internal.InboundTrafficController;

final class DecodedHttpResponse
extends DefaultHttpResponse {
    private final EventLoop eventLoop;
    private InboundTrafficController inboundTrafficController;
    private long writtenBytes;

    DecodedHttpResponse(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    void init(InboundTrafficController inboundTrafficController) {
        this.inboundTrafficController = inboundTrafficController;
    }

    long writtenBytes() {
        return this.writtenBytes;
    }

    public void subscribe(Subscriber<? super HttpObject> subscriber) {
        this.subscribe(subscriber, (Executor)this.eventLoop);
    }

    public boolean write(HttpObject obj) {
        boolean published = super.write((Object)obj);
        if (published && obj instanceof HttpData) {
            int length = ((HttpData)obj).length();
            this.inboundTrafficController.inc(length);
            this.writtenBytes += (long)length;
        }
        return published;
    }

    protected void onRemoval(HttpObject obj) {
        if (obj instanceof HttpData) {
            int length = ((HttpData)obj).length();
            this.inboundTrafficController.dec(length);
        }
    }
}

