package org.xbib.helianthus.client;

import static java.util.Objects.requireNonNull;

import org.xbib.helianthus.common.Request;
import org.xbib.helianthus.common.Response;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class ClientDecorationBuilder {

    private final List<ClientDecoration.Entry<?, ?>> entries = new ArrayList<>();

    public <T extends Client<? super I, ? extends O>, R extends Client<I, O>,
            I extends Request, O extends Response>
    ClientDecorationBuilder add(Class<I> requestType, Class<O> responseType, Function<T, R> decorator) {

        requireNonNull(requestType, "requestType");
        requireNonNull(responseType, "responseType");
        requireNonNull(decorator, "decorator");

        entries.add(new ClientDecoration.Entry<>(requestType, responseType, decorator));
        return this;
    }

    public ClientDecoration build() {
        return new ClientDecoration(entries);
    }
}
