package org.xbib.helianthus.client;

import static java.util.Objects.requireNonNull;

import java.net.URI;
import java.util.Arrays;

public interface ClientOptionDerivable<T> {

    /**
     * Creates a new derived client that connects to the same {@link URI} with the specified {@code client}
     * with the specified {@code additionalOptions}. Note that the derived client will use the options of
     * the specified {@code client} unless specified in {@code additionalOptions}.
     */
    default T withOptions(ClientOptionValue<?>... additionalOptions) {
        requireNonNull(additionalOptions, "additionalOptions");
        return withOptions(Arrays.asList(additionalOptions));
    }

    /**
     * Creates a new derived client that connects to the same {@link URI} with the specified {@code client}
     * with the specified {@code additionalOptions}. Note that the derived client will use the options of
     * the specified {@code client} unless specified in {@code additionalOptions}.
     */
    T withOptions(Iterable<ClientOptionValue<?>> additionalOptions);
}
