package org.xbib.helianthus.client;

import io.netty.util.AttributeKey;
import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.http.HttpHeaders;

import java.time.Duration;

/**
 * Provides information about an invocation and related utilities. Every client request has its own
 * {@link ClientRequestContext} instance.
 */
public interface ClientRequestContext extends RequestContext {

    AttributeKey<HttpHeaders> HTTP_HEADERS = AttributeKey.valueOf(ClientRequestContext.class, "HTTP_HEADERS");

    Endpoint endpoint();

    ClientOptions options();

    long writeTimeoutMillis();

    void setWriteTimeoutMillis(long writeTimeoutMillis);

    void setWriteTimeout(Duration writeTimeout);

    long responseTimeoutMillis();

    void setResponseTimeoutMillis(long responseTimeoutMillis);

    void setResponseTimeout(Duration responseTimeout);

    long maxResponseLength();

    void setMaxResponseLength(long maxResponseLength);
}
