package org.xbib.helianthus.client;

import org.xbib.helianthus.common.TimeoutException;
import org.xbib.helianthus.common.util.Exceptions;

/**
 * A {@link TimeoutException} raised when a client failed to send a request to the wire within timeout.
 */
public final class WriteTimeoutException extends TimeoutException {

    private static final long serialVersionUID = 2556616197251937869L;

    private static final WriteTimeoutException INSTANCE = Exceptions.clearTrace(new WriteTimeoutException());

    /**
     * Creates a new instance.
     */
    private WriteTimeoutException() {
    }

    public static WriteTimeoutException get() {
        return Exceptions.isVerbose() ? new WriteTimeoutException() : INSTANCE;
    }
}
