package org.xbib.helianthus.client.http;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;

/**
 * A container for information returned in an HTTP response. This is a simpler version of
 * {@link FullHttpResponse} which only uses a byte array to avoid callers having to worry about memory
 * management.
 */
@Deprecated
public class SimpleHttpResponse {

    private final HttpResponseStatus status;
    private final HttpHeaders headers;
    private final byte[] content;

    SimpleHttpResponse(HttpResponseStatus status, HttpHeaders headers, byte[] content) {
        this.status = status;
        this.headers = headers;
        this.content = content;
    }

    /**
     * Returns the HTTP status.
     */
    public HttpResponseStatus status() {
        return status;
    }

    /**
     * Returns the HTTP response headers.
     */
    public HttpHeaders headers() {
        return headers;
    }

    /**
     * Returns the HTTP response content.
     *
     * @return the HTTP response content, or an empty array if there's no content
     */
    public byte[] content() {
        return content;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        buf.append("status: ").append(status);
        buf.append(", headers: ").append(headers);
        buf.append(", content: ");
        if (content.length > 0) {
            buf.append("<length: ").append(content.length).append('>');
        } else {
            buf.append("<none>");
        }
        buf.append(')');
        return buf.toString();
    }
}
