/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddresses;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.net.ssl.TrustManagerFactory;
import org.xbib.helianthus.client.SessionOption;
import org.xbib.helianthus.client.SessionOptionValue;
import org.xbib.helianthus.client.dns.CustomDnsAddressResolverGroup;
import org.xbib.helianthus.client.pool.KeyedChannelPoolHandler;
import org.xbib.helianthus.client.pool.PoolKey;
import org.xbib.helianthus.common.util.AbstractOptionValue;
import org.xbib.helianthus.common.util.AbstractOptions;

public class SessionOptions
extends AbstractOptions {
    private static final Logger logger = Logger.getLogger(SessionOptions.class.getName());
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofMillis(3200L);
    private static final Duration DEFAULT_IDLE_TIMEOUT = Duration.ofSeconds(10L);
    private static final Integer DEFAULT_MAX_CONCURRENCY = Integer.MAX_VALUE;
    private static final Boolean DEFAULT_USE_HTTP2_PREFACE = "true".equals(System.getProperty("org.xbib.helianthus.defaultUseHttp2Preface", "false"));
    private static final SessionOptionValue<?>[] DEFAULT_OPTION_VALUES = new SessionOptionValue[]{SessionOption.CONNECT_TIMEOUT.newValue(DEFAULT_CONNECTION_TIMEOUT), SessionOption.IDLE_TIMEOUT.newValue(DEFAULT_IDLE_TIMEOUT), SessionOption.MAX_CONCURRENCY.newValue(DEFAULT_MAX_CONCURRENCY), SessionOption.USE_HTTP2_PREFACE.newValue(DEFAULT_USE_HTTP2_PREFACE), SessionOption.ADDRESS_RESOLVER_GROUP.newValue(new CustomDnsAddressResolverGroup(SessionOptions.datagramChannelType(), DnsServerAddresses.defaultAddresses()))};
    public static final SessionOptions DEFAULT = new SessionOptions(DEFAULT_OPTION_VALUES);

    private SessionOptions(SessionOptionValue<?> ... options) {
        super(SessionOptions::validateValue, (AbstractOptionValue[])options);
    }

    private SessionOptions(SessionOptions baseOptions, SessionOptionValue<?> ... options) {
        super(SessionOptions::validateValue, (AbstractOptions)baseOptions, (AbstractOptionValue[])options);
    }

    private SessionOptions(SessionOptions baseOptions, Iterable<SessionOptionValue<?>> options) {
        super(SessionOptions::validateValue, (AbstractOptions)baseOptions, options);
    }

    public static SessionOptions of(SessionOptionValue<?> ... options) {
        return new SessionOptions(DEFAULT, options);
    }

    public static SessionOptions of(Iterable<SessionOptionValue<?>> options) {
        return new SessionOptions(DEFAULT, options);
    }

    private static <T> SessionOptionValue<T> validateValue(SessionOptionValue<T> optionValue) {
        Objects.requireNonNull(optionValue, "value");
        SessionOption option = (SessionOption)optionValue.option();
        Object value = optionValue.value();
        if (option == SessionOption.CONNECT_TIMEOUT) {
            SessionOptions.validateConnectionTimeout((Duration)value);
        } else if (option == SessionOption.IDLE_TIMEOUT) {
            SessionOptions.validateIdleTimeout((Duration)value);
        } else if (option == SessionOption.MAX_CONCURRENCY) {
            SessionOptions.validateMaxConcurrency((Integer)value);
        }
        return optionValue;
    }

    private static Duration validateConnectionTimeout(Duration connectionTimeout) {
        Objects.requireNonNull(connectionTimeout, "connectionTimeout");
        if (connectionTimeout.isNegative() || connectionTimeout.isZero()) {
            throw new IllegalArgumentException("connectTimeout: " + connectionTimeout + " (expected: > 0)");
        }
        return connectionTimeout;
    }

    private static Duration validateIdleTimeout(Duration idleTimeout) {
        Objects.requireNonNull(idleTimeout, "idleTimeout");
        if (idleTimeout.isNegative()) {
            throw new IllegalArgumentException("idleTimeout: " + idleTimeout + " (expected: >= 0)");
        }
        return idleTimeout;
    }

    private static int validateMaxConcurrency(int maxConcurrency) {
        if (maxConcurrency <= 0) {
            throw new IllegalArgumentException("maxConcurrency: " + maxConcurrency + " (expected: > 0)");
        }
        return maxConcurrency;
    }

    public <T> Optional<T> get(SessionOption<T> option) {
        return this.get0(option);
    }

    public <T> T getOrElse(SessionOption<T> option, T defaultValue) {
        return (T)this.getOrElse0(option, defaultValue);
    }

    public Map<SessionOption<Object>, SessionOptionValue<Object>> asMap() {
        return this.asMap0();
    }

    public Duration connectTimeout() {
        return this.getOrElse(SessionOption.CONNECT_TIMEOUT, DEFAULT_CONNECTION_TIMEOUT);
    }

    public long connectTimeoutMillis() {
        return this.connectTimeout().toMillis();
    }

    public Optional<EventLoopGroup> eventLoopGroup() {
        return this.get(SessionOption.EVENT_LOOP_GROUP);
    }

    public Optional<TrustManagerFactory> trustManagerFactory() {
        return this.get(SessionOption.TRUST_MANAGER_FACTORY);
    }

    public Optional<AddressResolverGroup<InetSocketAddress>> addressResolverGroup() {
        Optional<AddressResolverGroup<InetSocketAddress>> value;
        Optional<AddressResolverGroup<InetSocketAddress>> castValue = value = this.get(SessionOption.ADDRESS_RESOLVER_GROUP);
        return castValue;
    }

    public Duration idleTimeout() {
        return this.getOrElse(SessionOption.IDLE_TIMEOUT, DEFAULT_IDLE_TIMEOUT);
    }

    public long idleTimeoutMillis() {
        return this.idleTimeout().toMillis();
    }

    public int maxConcurrency() {
        return this.getOrElse(SessionOption.MAX_CONCURRENCY, DEFAULT_MAX_CONCURRENCY);
    }

    public Function<KeyedChannelPoolHandler<PoolKey>, KeyedChannelPoolHandler<PoolKey>> poolHandlerDecorator() {
        return this.getOrElse(SessionOption.POOL_HANDLER_DECORATOR, Function.identity());
    }

    public boolean useHttp2Preface() {
        return this.getOrElse(SessionOption.USE_HTTP2_PREFACE, DEFAULT_USE_HTTP2_PREFACE);
    }

    private static Class<? extends DatagramChannel> datagramChannelType() {
        return Epoll.isAvailable() ? EpollDatagramChannel.class : NioDatagramChannel.class;
    }

    static {
        logger.info(MessageFormat.format("defaultUseHttp2Preface: {0}", DEFAULT_USE_HTTP2_PREFACE));
    }
}

