/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.StampedLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.util.LruMap;

public final class SessionProtocolNegotiationCache {
    private static final Logger logger = Logger.getLogger(SessionProtocolNegotiationCache.class.getName());
    private static final StampedLock lock = new StampedLock();
    private static final Map<String, CacheEntry> cache = new LruMap<String, CacheEntry>(65536){
        private static final long serialVersionUID = -2506868886873712772L;

        protected boolean removeEldestEntry(Map.Entry<String, CacheEntry> eldest) {
            boolean remove = super.removeEldestEntry(eldest);
            if (remove) {
                logger.log(Level.FINE, MessageFormat.format("Evicted: '{0}' does not support {1}", eldest.getKey(), eldest.getValue()));
            }
            return remove;
        }
    };

    private SessionProtocolNegotiationCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUnsupported(SocketAddress remoteAddress, SessionProtocol protocol) {
        CacheEntry e;
        String key = SessionProtocolNegotiationCache.key(remoteAddress);
        long stamp = lock.readLock();
        try {
            e = cache.get(key);
        }
        finally {
            lock.unlockRead(stamp);
        }
        if (e == null) {
            return false;
        }
        return e.isUnsupported(protocol);
    }

    public static void setUnsupported(SocketAddress remoteAddress, SessionProtocol protocol) {
        String key = SessionProtocolNegotiationCache.key(remoteAddress);
        CacheEntry e = SessionProtocolNegotiationCache.getOrCreate(key);
        if (e.addUnsupported(protocol)) {
            logger.log(Level.FINE, MessageFormat.format("Updated: '{0}' does not support {1}", key, protocol), e);
        }
    }

    public static void clear() {
        int size;
        long stamp = lock.readLock();
        try {
            size = cache.size();
            if (size == 0) {
                return;
            }
            stamp = SessionProtocolNegotiationCache.convertToWriteLock(stamp);
            size = cache.size();
            cache.clear();
        }
        finally {
            lock.unlock(stamp);
        }
        if (size != 0 && logger.isLoggable(Level.FINE)) {
            if (size != 1) {
                logger.fine(MessageFormat.format("Cleared: {0} entries", size));
            } else {
                logger.fine("Cleared: 1 entry");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CacheEntry getOrCreate(String key) {
        long stamp = lock.readLock();
        try {
            CacheEntry entry = cache.get(key);
            if (entry != null) {
                CacheEntry cacheEntry = entry;
                return cacheEntry;
            }
            stamp = SessionProtocolNegotiationCache.convertToWriteLock(stamp);
            CacheEntry cacheEntry = cache.computeIfAbsent(key, CacheEntry::new);
            return cacheEntry;
        }
        finally {
            lock.unlock(stamp);
        }
    }

    private static String key(SocketAddress remoteAddress) {
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        if (!(remoteAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("remoteAddress: " + remoteAddress + " (expected: an " + InetSocketAddress.class.getSimpleName() + ')');
        }
        InetSocketAddress raddr = (InetSocketAddress)remoteAddress;
        String host = raddr.getHostString();
        return new StringBuilder(host.length() + 6).append(host).append(':').append(raddr.getPort()).toString();
    }

    private static long convertToWriteLock(long stamp) {
        long writeStamp = lock.tryConvertToWriteLock(stamp);
        if (writeStamp == 0L) {
            lock.unlockRead(stamp);
            stamp = lock.writeLock();
        } else {
            stamp = writeStamp;
        }
        return stamp;
    }

    private static final class CacheEntry {
        private volatile EnumSet<SessionProtocol> unsupported = EnumSet.noneOf(SessionProtocol.class);

        CacheEntry(String key) {
        }

        boolean addUnsupported(SessionProtocol protocol) {
            EnumSet<SessionProtocol> unsupported = this.unsupported;
            if (unsupported.contains(protocol)) {
                return false;
            }
            EnumSet<SessionProtocol> copy = EnumSet.copyOf(unsupported);
            copy.add(protocol);
            this.unsupported = copy;
            return true;
        }

        boolean isUnsupported(SessionProtocol protocol) {
            Objects.requireNonNull(protocol, "protocol");
            return this.unsupported.contains(protocol);
        }

        public String toString() {
            return this.unsupported.toString();
        }
    }
}

