/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import io.netty.channel.EventLoop;
import java.util.function.Function;
import java.util.function.Supplier;
import org.xbib.helianthus.client.Client;
import org.xbib.helianthus.client.ClientOptionDerivable;
import org.xbib.helianthus.client.ClientOptionValue;
import org.xbib.helianthus.client.ClientOptions;
import org.xbib.helianthus.client.DefaultClientRequestContext;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.common.Request;
import org.xbib.helianthus.common.Response;
import org.xbib.helianthus.common.SessionProtocol;

public abstract class UserClient<T, I extends Request, O extends Response>
implements ClientOptionDerivable<T> {
    private final Client<I, O> delegate;
    private final Supplier<EventLoop> eventLoopSupplier;
    private final SessionProtocol sessionProtocol;
    private final ClientOptions options;
    private final Endpoint endpoint;

    protected UserClient(Client<I, O> delegate, Supplier<EventLoop> eventLoopSupplier, SessionProtocol sessionProtocol, ClientOptions options, Endpoint endpoint) {
        this.delegate = delegate;
        this.eventLoopSupplier = eventLoopSupplier;
        this.sessionProtocol = sessionProtocol;
        this.options = options;
        this.endpoint = endpoint;
    }

    protected final <U extends Client<I, O>> U delegate() {
        return (U)this.delegate;
    }

    protected final EventLoop eventLoop() {
        return this.eventLoopSupplier.get();
    }

    protected final SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    protected final ClientOptions options() {
        return this.options;
    }

    protected final Endpoint endpoint() {
        return this.endpoint;
    }

    protected final O execute(String method, String path, I req, Function<Throwable, O> fallback) {
        return this.execute(this.eventLoop(), method, path, req, fallback);
    }

    protected final O execute(EventLoop eventLoop, String method, String path, I req, Function<Throwable, O> fallback) {
        DefaultClientRequestContext ctx = new DefaultClientRequestContext(eventLoop, this.sessionProtocol, this.endpoint, method, path, this.options, req);
        try {
            return this.delegate().execute(ctx, req);
        }
        catch (Throwable cause) {
            ctx.responseLogBuilder().end(cause);
            return (O)((Response)fallback.apply(cause));
        }
    }

    @Override
    public final T withOptions(ClientOptionValue<?> ... additionalOptions) {
        ClientOptions options = ClientOptions.of(this.options(), additionalOptions);
        return this.newInstance((Client<I, O>)this.delegate(), this.eventLoopSupplier, this.sessionProtocol(), options, this.endpoint());
    }

    @Override
    public final T withOptions(Iterable<ClientOptionValue<?>> additionalOptions) {
        ClientOptions options = ClientOptions.of(this.options(), additionalOptions);
        return this.newInstance((Client<I, O>)this.delegate(), this.eventLoopSupplier, this.sessionProtocol(), options, this.endpoint());
    }

    protected abstract T newInstance(Client<I, O> var1, Supplier<EventLoop> var2, SessionProtocol var3, ClientOptions var4, Endpoint var5);
}

