/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.channel.EventLoop;
import java.util.function.Supplier;
import org.xbib.helianthus.client.Client;
import org.xbib.helianthus.client.ClientOptions;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.client.UserClient;
import org.xbib.helianthus.client.http.HttpClient;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.AggregatedHttpMessage;
import org.xbib.helianthus.common.http.DefaultHttpRequest;
import org.xbib.helianthus.common.http.DefaultHttpResponse;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaderNames;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpRequest;
import org.xbib.helianthus.common.http.HttpResponse;

final class DefaultHttpClient
extends UserClient<HttpClient, HttpRequest, HttpResponse>
implements HttpClient {
    DefaultHttpClient(Client<HttpRequest, HttpResponse> delegate, Supplier<EventLoop> eventLoopSupplier, SessionProtocol sessionProtocol, ClientOptions options, Endpoint endpoint) {
        super(delegate, eventLoopSupplier, sessionProtocol, options, endpoint);
    }

    EventLoop eventLoop0() {
        return this.eventLoop();
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        return this.execute(this.eventLoop(), req);
    }

    private HttpResponse execute(EventLoop eventLoop, HttpRequest req) {
        return this.execute(eventLoop, req.method().name(), req.path(), req, cause -> {
            DefaultHttpResponse res = new DefaultHttpResponse();
            res.close(cause);
            return res;
        });
    }

    @Override
    public HttpResponse execute(AggregatedHttpMessage aggregatedReq) {
        return this.execute(this.eventLoop(), aggregatedReq);
    }

    HttpResponse execute(EventLoop eventLoop, AggregatedHttpMessage aggregatedReq) {
        HttpHeaders trailingHeaders;
        HttpHeaders headers = aggregatedReq.headers();
        DefaultHttpRequest req = new DefaultHttpRequest(headers);
        HttpData content = aggregatedReq.content();
        if (!content.isEmpty()) {
            headers.setInt((Object)HttpHeaderNames.CONTENT_LENGTH, content.length());
            req.write((Object)content);
        }
        if (!(trailingHeaders = aggregatedReq.trailingHeaders()).isEmpty()) {
            req.write((Object)trailingHeaders);
        }
        req.close();
        return this.execute(eventLoop, (HttpRequest)req);
    }

    @Override
    protected HttpClient newInstance(Client<HttpRequest, HttpResponse> delegate, Supplier<EventLoop> eventLoopSupplier, SessionProtocol sessionProtocol, ClientOptions options, Endpoint endpoint) {
        return new DefaultHttpClient(delegate, eventLoopSupplier, sessionProtocol, options, endpoint);
    }
}

