/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.xbib.helianthus.client.ClientOptionValue;
import org.xbib.helianthus.client.http.DefaultHttpClient;
import org.xbib.helianthus.client.http.SimpleHttpClient;
import org.xbib.helianthus.client.http.SimpleHttpRequest;
import org.xbib.helianthus.client.http.SimpleHttpResponse;
import org.xbib.helianthus.common.http.AggregatedHttpMessage;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpMethod;
import org.xbib.helianthus.common.http.HttpResponse;
import org.xbib.helianthus.common.util.CompletionActions;
import org.xbib.helianthus.common.util.Functions;
import org.xbib.helianthus.internal.http.HelianthusHttpUtil;

final class DefaultSimpleHttpClient
implements SimpleHttpClient {
    private final DefaultHttpClient client;

    DefaultSimpleHttpClient(DefaultHttpClient client) {
        this.client = client;
    }

    @Override
    public Future<SimpleHttpResponse> execute(SimpleHttpRequest sReq) {
        EventLoop eventLoop = this.client.eventLoop0();
        Promise promise = eventLoop.newPromise();
        try {
            AggregatedHttpMessage aReq = AggregatedHttpMessage.of((HttpMethod)HttpMethod.valueOf((String)sReq.method().name()), (String)sReq.uri().getPath(), (HttpData)HttpData.of((byte[])sReq.content()));
            HelianthusHttpUtil.toHelianthus((HttpHeaders)sReq.headers(), (org.xbib.helianthus.common.http.HttpHeaders)aReq.headers());
            HttpResponse res = this.client.execute(eventLoop, aReq);
            ((CompletableFuture)res.aggregate().handle(Functions.voidFunction((aRes, cause) -> {
                if (cause != null) {
                    promise.setFailure(cause);
                } else {
                    try {
                        HttpData aContent = aRes.content();
                        byte[] content = aContent.offset() == 0 && aContent.length() == aContent.array().length ? aContent.array() : Arrays.copyOfRange(aContent.array(), aContent.offset(), aContent.length());
                        SimpleHttpResponse sRes = new SimpleHttpResponse(HttpResponseStatus.valueOf((int)aRes.status().code()), HelianthusHttpUtil.toNettyHttp1((org.xbib.helianthus.common.http.HttpHeaders)aRes.headers()), content);
                        promise.setSuccess((Object)sRes);
                    }
                    catch (Throwable t) {
                        promise.setFailure(t);
                    }
                }
            }))).exceptionally(CompletionActions::log);
        }
        catch (Throwable t) {
            promise.setFailure(t);
        }
        return promise;
    }

    @Override
    public SimpleHttpClient withOptions(Iterable<ClientOptionValue<?>> additionalOptions) {
        return new DefaultSimpleHttpClient((DefaultHttpClient)this.client.withOptions(additionalOptions));
    }
}

