/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.xbib.helianthus.client.Client;
import org.xbib.helianthus.client.ClientOptions;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.client.NonDecoratingClientFactory;
import org.xbib.helianthus.client.SessionOptions;
import org.xbib.helianthus.client.http.DefaultHttpClient;
import org.xbib.helianthus.client.http.DefaultSimpleHttpClient;
import org.xbib.helianthus.client.http.HttpClient;
import org.xbib.helianthus.client.http.HttpClientDelegate;
import org.xbib.helianthus.client.http.SimpleHttpClient;
import org.xbib.helianthus.common.Scheme;
import org.xbib.helianthus.common.SerializationFormat;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.HttpRequest;
import org.xbib.helianthus.common.http.HttpResponse;

public class HttpClientFactory
extends NonDecoratingClientFactory {
    private static final Set<Scheme> SUPPORTED_SCHEMES;
    private final HttpClientDelegate delegate;

    public HttpClientFactory() {
        this(SessionOptions.DEFAULT);
    }

    public HttpClientFactory(SessionOptions options) {
        super(options);
        this.delegate = new HttpClientDelegate(this.baseBootstrap(), options);
    }

    private static void validateClientType(Class<?> clientType) {
        if (clientType != HttpClient.class && clientType != SimpleHttpClient.class && clientType != Client.class) {
            throw new IllegalArgumentException("clientType: " + clientType + " (expected: " + HttpClient.class.getSimpleName() + ", " + SimpleHttpClient.class.getSimpleName() + " or " + Client.class.getSimpleName() + ')');
        }
    }

    @Override
    public Set<Scheme> supportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    @Override
    public <T> T newClient(URI uri, Class<T> clientType, ClientOptions options) {
        DefaultSimpleHttpClient client;
        Scheme scheme = this.validate(uri, clientType, options);
        HttpClientFactory.validateClientType(clientType);
        Client<HttpRequest, HttpResponse> delegate = options.decoration().decorate(HttpRequest.class, HttpResponse.class, new HttpClientDelegate(this.baseBootstrap(), this.options()));
        if (clientType == Client.class) {
            Client<HttpRequest, HttpResponse> castClient = delegate;
            return (T)castClient;
        }
        Endpoint endpoint = HttpClientFactory.newEndpoint(uri);
        if (clientType == HttpClient.class) {
            DefaultHttpClient client2;
            DefaultHttpClient castClient = client2 = new DefaultHttpClient(delegate, this.eventLoopSupplier(), scheme.sessionProtocol(), options, endpoint);
            return (T)castClient;
        }
        DefaultSimpleHttpClient castClient = client = new DefaultSimpleHttpClient(new DefaultHttpClient(delegate, this.eventLoopSupplier(), scheme.sessionProtocol(), options, endpoint));
        return (T)castClient;
    }

    @Override
    public void close() {
        this.delegate.close();
        super.close();
    }

    static {
        HashSet<Scheme> set = new HashSet<Scheme>();
        for (SessionProtocol p : SessionProtocol.ofHttp()) {
            set.add(Scheme.of((SerializationFormat)SerializationFormat.NONE, (SessionProtocol)p));
        }
        SUPPORTED_SCHEMES = set;
    }
}

