/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.xbib.helianthus.client.WriteTimeoutException;
import org.xbib.helianthus.client.http.HttpSession;
import org.xbib.helianthus.common.ClosedSessionException;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.common.http.HttpResponseWriter;
import org.xbib.helianthus.common.logging.RequestLog;
import org.xbib.helianthus.common.logging.RequestLogBuilder;
import org.xbib.helianthus.common.stream.ClosedPublisherException;
import org.xbib.helianthus.common.util.Exceptions;
import org.xbib.helianthus.internal.http.HttpObjectEncoder;

final class HttpRequestSubscriber
implements Subscriber<HttpObject>,
ChannelFutureListener {
    private static final Logger logger = Logger.getLogger(HttpRequestSubscriber.class.getName());
    private final ChannelHandlerContext ctx;
    private final HttpObjectEncoder encoder;
    private final int id;
    private final HttpHeaders firstHeaders;
    private final HttpResponseWriter response;
    private final RequestLogBuilder logBuilder;
    private final long timeoutMillis;
    private Subscription subscription;
    private ScheduledFuture<?> timeoutFuture;
    private State state = State.NEEDS_DATA_OR_TRAILING_HEADERS;

    HttpRequestSubscriber(Channel ch, HttpObjectEncoder encoder, int id, HttpHeaders firstHeaders, HttpResponseWriter response, RequestLogBuilder logBuilder, long timeoutMillis) {
        this.ctx = ch.pipeline().lastContext();
        this.encoder = encoder;
        this.id = id;
        this.firstHeaders = firstHeaders;
        this.response = response;
        this.logBuilder = logBuilder;
        this.timeoutMillis = timeoutMillis;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (future.isSuccess()) {
            if (this.state != State.DONE) {
                this.subscription.request(1L);
            }
            return;
        }
        this.fail(future.cause());
        Throwable cause = future.cause();
        if (!(cause instanceof ClosedPublisherException)) {
            Channel ch = future.channel();
            Exceptions.logIfUnexpected((Logger)logger, (Channel)ch, (SessionProtocol)HttpSession.get(ch).protocol(), (Throwable)cause);
            ch.close();
        }
    }

    public void onSubscribe(Subscription subscription) {
        assert (this.subscription == null);
        this.subscription = subscription;
        EventLoop eventLoop = this.ctx.channel().eventLoop();
        if (this.timeoutMillis > 0L) {
            this.timeoutFuture = eventLoop.schedule(() -> {
                if (this.state != State.DONE) {
                    this.failAndRespond((Throwable)((Object)WriteTimeoutException.get()));
                }
            }, this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        eventLoop.execute(this::writeFirstHeader);
    }

    private void writeFirstHeader() {
        Channel ch = this.ctx.channel();
        HttpHeaders firstHeaders = this.firstHeaders;
        String host = firstHeaders.authority();
        if (host == null) {
            host = ((InetSocketAddress)ch.remoteAddress()).getHostString();
        }
        this.logBuilder.start(ch, HttpSession.get(ch).protocol(), host, firstHeaders.method().name(), firstHeaders.path());
        this.logBuilder.attr(RequestLog.HTTP_HEADERS).set((Object)firstHeaders);
        this.encoder.writeHeaders(this.ctx, this.id, this.streamId(), firstHeaders, false).addListener((GenericFutureListener)this);
        this.ctx.flush();
    }

    public void onNext(HttpObject o) {
        if (!(o instanceof HttpData) && !(o instanceof HttpHeaders)) {
            throw this.newIllegalStateException("published an HttpObject that's neither Http2Headers nor Http2Data: " + o);
        }
        boolean endOfStream = false;
        switch (this.state) {
            case NEEDS_DATA_OR_TRAILING_HEADERS: {
                if (!(o instanceof HttpHeaders)) break;
                HttpHeaders trailingHeaders = (HttpHeaders)o;
                if (trailingHeaders.status() != null) {
                    throw this.newIllegalStateException("published a trailing HttpHeaders with status: " + o);
                }
                endOfStream = true;
                break;
            }
            case DONE: {
                return;
            }
        }
        this.write(o, endOfStream, true);
    }

    public void onError(Throwable cause) {
        this.failAndRespond(cause);
    }

    public void onComplete() {
        if (!this.cancelTimeout()) {
            return;
        }
        if (this.state != State.DONE) {
            this.write((HttpObject)HttpData.EMPTY_DATA, true, true);
        }
    }

    private void write(HttpObject o, boolean endOfStream, boolean flush) {
        if (this.state == State.DONE) {
            throw this.newIllegalStateException("a request publisher published an HttpObject after a trailing HttpHeaders: " + o);
        }
        Channel ch = this.ctx.channel();
        if (!ch.isActive()) {
            this.fail((Throwable)ClosedSessionException.get());
            return;
        }
        if (endOfStream) {
            this.setDone();
        }
        ch.eventLoop().execute(() -> this.write0(o, endOfStream, flush));
    }

    private void write0(HttpObject o, boolean endOfStream, boolean flush) {
        ChannelFuture future;
        if (o instanceof HttpData) {
            HttpData data = (HttpData)o;
            future = this.encoder.writeData(this.ctx, this.id, this.streamId(), data, endOfStream);
            this.logBuilder.increaseContentLength((long)data.length());
        } else if (o instanceof HttpHeaders) {
            future = this.encoder.writeHeaders(this.ctx, this.id, this.streamId(), (HttpHeaders)o, endOfStream);
        } else {
            throw new Error();
        }
        if (endOfStream) {
            this.logBuilder.end();
        }
        future.addListener((GenericFutureListener)this);
        if (flush) {
            this.ctx.flush();
        }
    }

    private int streamId() {
        return (this.id << 1) + 1;
    }

    private void fail(Throwable cause) {
        this.setDone();
        this.logBuilder.end(cause);
    }

    private void setDone() {
        this.cancelTimeout();
        this.state = State.DONE;
        this.subscription.cancel();
    }

    private void failAndRespond(Throwable cause) {
        Http2Error error;
        this.fail(cause);
        Channel ch = this.ctx.channel();
        if (this.response.isOpen()) {
            this.response.close(cause);
            error = Http2Error.INTERNAL_ERROR;
        } else if (cause instanceof WriteTimeoutException) {
            error = Http2Error.CANCEL;
        } else {
            Exceptions.logIfUnexpected((Logger)logger, (Channel)ch, (SessionProtocol)HttpSession.get(ch).protocol(), (String)"a request publisher raised an exception", (Throwable)cause);
            error = Http2Error.INTERNAL_ERROR;
        }
        if (ch.isActive()) {
            this.encoder.writeReset(this.ctx, this.id, this.streamId(), error);
            this.ctx.flush();
        }
    }

    private boolean cancelTimeout() {
        ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
        if (timeoutFuture == null) {
            return true;
        }
        return timeoutFuture.cancel(false);
    }

    private IllegalStateException newIllegalStateException(String msg) {
        IllegalStateException cause = new IllegalStateException(msg);
        this.fail(cause);
        return cause;
    }

    static enum State {
        NEEDS_DATA_OR_TRAILING_HEADERS,
        DONE;

    }
}

