/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.helianthus.client.ResponseTimeoutException;
import org.xbib.helianthus.client.http.DecodedHttpResponse;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.common.http.HttpResponseWriter;
import org.xbib.helianthus.common.http.HttpStatus;
import org.xbib.helianthus.common.http.HttpStatusClass;
import org.xbib.helianthus.common.logging.ResponseLog;
import org.xbib.helianthus.common.logging.ResponseLogBuilder;
import org.xbib.helianthus.common.util.Exceptions;
import org.xbib.helianthus.internal.InboundTrafficController;

abstract class HttpResponseDecoder {
    private static final Logger logger = Logger.getLogger(HttpResponseDecoder.class.getName());
    private final IntObjectMap<HttpResponseWrapper> responses = new IntObjectHashMap();
    private final InboundTrafficController inboundTrafficController;
    private boolean disconnectWhenFinished;

    HttpResponseDecoder(Channel channel) {
        this.inboundTrafficController = new InboundTrafficController(channel);
    }

    final InboundTrafficController inboundTrafficController() {
        return this.inboundTrafficController;
    }

    final void addResponse(int id, DecodedHttpResponse res, ResponseLogBuilder logBuilder, long responseTimeoutMillis, long maxContentLength) {
        HttpResponseWriter oldRes = (HttpResponseWriter)this.responses.put(id, (Object)new HttpResponseWrapper(res, logBuilder, responseTimeoutMillis, maxContentLength));
        assert (oldRes == null) : "addResponse(" + id + ", " + (Object)((Object)res) + ", " + responseTimeoutMillis + "): " + oldRes;
    }

    final HttpResponseWrapper getResponse(int id) {
        return (HttpResponseWrapper)this.responses.get(id);
    }

    final HttpResponseWrapper getResponse(int id, boolean remove) {
        return remove ? this.removeResponse(id) : this.getResponse(id);
    }

    final HttpResponseWrapper removeResponse(int id) {
        return (HttpResponseWrapper)this.responses.remove(id);
    }

    final boolean hasUnfinishedResponses() {
        return !this.responses.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void failUnfinishedResponses(Throwable cause) {
        try {
            for (HttpResponseWrapper res : this.responses.values()) {
                res.close(cause);
            }
        }
        finally {
            this.responses.clear();
        }
    }

    final void disconnectWhenFinished() {
        this.disconnectWhenFinished = true;
    }

    final boolean needsToDisconnect() {
        return this.disconnectWhenFinished && !this.hasUnfinishedResponses();
    }

    static final class HttpResponseWrapper
    implements HttpResponseWriter,
    Runnable {
        private final DecodedHttpResponse delegate;
        private final ResponseLogBuilder logBuilder;
        private final long responseTimeoutMillis;
        private final long maxContentLength;
        private ScheduledFuture<?> responseTimeoutFuture;

        HttpResponseWrapper(DecodedHttpResponse delegate, ResponseLogBuilder logBuilder, long responseTimeoutMillis, long maxContentLength) {
            this.delegate = delegate;
            this.logBuilder = logBuilder;
            this.responseTimeoutMillis = responseTimeoutMillis;
            this.maxContentLength = maxContentLength;
        }

        void scheduleTimeout(ChannelHandlerContext ctx) {
            if (this.responseTimeoutMillis <= 0L) {
                return;
            }
            this.responseTimeoutFuture = ctx.channel().eventLoop().schedule((Runnable)this, this.responseTimeoutMillis, TimeUnit.MILLISECONDS);
        }

        long maxContentLength() {
            return this.maxContentLength;
        }

        long writtenBytes() {
            return this.delegate.writtenBytes();
        }

        @Override
        public void run() {
            ResponseTimeoutException cause = ResponseTimeoutException.get();
            this.delegate.close((Throwable)((Object)cause));
            this.logBuilder.end((Throwable)((Object)cause));
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public boolean write(HttpObject o) {
            if (o instanceof HttpHeaders) {
                this.logBuilder.start();
                HttpHeaders headers = (HttpHeaders)o;
                HttpStatus status = headers.status();
                if (status != null && status.codeClass() != HttpStatusClass.INFORMATIONAL) {
                    this.logBuilder.statusCode(status.code());
                    this.logBuilder.attr(ResponseLog.HTTP_HEADERS).set((Object)headers);
                }
            } else if (o instanceof HttpData) {
                this.logBuilder.increaseContentLength((long)((HttpData)o).length());
            }
            return this.delegate.write(o);
        }

        public boolean write(Supplier<? extends HttpObject> o) {
            return this.delegate.write(o);
        }

        public CompletableFuture<Void> onDemand(Runnable task) {
            return this.delegate.onDemand(task);
        }

        public void close() {
            if (this.cancelTimeout()) {
                this.delegate.close();
                this.logBuilder.end();
            }
        }

        public void close(Throwable cause) {
            if (this.cancelTimeout()) {
                this.delegate.close(cause);
                this.logBuilder.end(cause);
            } else if (!Exceptions.isExpected((Throwable)cause)) {
                logger.log(Level.WARNING, "Unexpected exception:", cause);
            }
        }

        private boolean cancelTimeout() {
            ScheduledFuture<?> responseTimeoutFuture = this.responseTimeoutFuture;
            if (responseTimeoutFuture == null) {
                return true;
            }
            return responseTimeoutFuture.cancel(false);
        }

        public void respond(HttpStatus status) {
            this.delegate.respond(status);
        }

        public void respond(HttpStatus status, String mediaType, String content) {
            this.delegate.respond(status, mediaType, content);
        }

        public void respond(HttpStatus status, String mediaType, String format, Object ... args) {
            this.delegate.respond(status, mediaType, format, args);
        }

        public void respond(HttpStatus status, String mediaType, byte[] content) {
            this.delegate.respond(status, mediaType, content);
        }

        public void respond(HttpStatus status, String mediaType, byte[] content, int offset, int length) {
            this.delegate.respond(status, mediaType, content, offset, length);
        }

        public String toString() {
            return ((Object)((Object)this.delegate)).toString();
        }
    }
}

