/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.reactivestreams.Subscriber;
import org.xbib.helianthus.client.ClientRequestContext;
import org.xbib.helianthus.client.SessionProtocolNegotiationException;
import org.xbib.helianthus.client.http.DecodedHttpResponse;
import org.xbib.helianthus.client.http.Http1ResponseDecoder;
import org.xbib.helianthus.client.http.Http2ClientConnectionHandler;
import org.xbib.helianthus.client.http.HttpRequestSubscriber;
import org.xbib.helianthus.client.http.HttpResponseDecoder;
import org.xbib.helianthus.client.http.HttpSession;
import org.xbib.helianthus.client.http.HttpSessionChannelFactory;
import org.xbib.helianthus.common.ClosedSessionException;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.HttpRequest;
import org.xbib.helianthus.common.http.HttpResponseWriter;
import org.xbib.helianthus.common.util.Exceptions;
import org.xbib.helianthus.internal.InboundTrafficController;
import org.xbib.helianthus.internal.http.Http1ObjectEncoder;
import org.xbib.helianthus.internal.http.Http2ObjectEncoder;
import org.xbib.helianthus.internal.http.HttpObjectEncoder;

final class HttpSessionHandler
extends ChannelDuplexHandler
implements HttpSession {
    private static final Logger logger = Logger.getLogger(HttpSessionHandler.class.getName());
    private static final int MAX_NUM_REQUESTS_SENT = 0x20000000;
    private final HttpSessionChannelFactory channelFactory;
    private final Channel channel;
    private final Promise<Channel> sessionPromise;
    private final ScheduledFuture<?> sessionTimeoutFuture;
    private volatile boolean active;
    private SessionProtocol protocol;
    private HttpResponseDecoder responseDecoder;
    private HttpObjectEncoder requestEncoder;
    private int numRequestsSent;
    private boolean needsRetryWithH1C;

    HttpSessionHandler(HttpSessionChannelFactory channelFactory, Channel channel, Promise<Channel> sessionPromise, ScheduledFuture<?> sessionTimeoutFuture) {
        this.channelFactory = Objects.requireNonNull(channelFactory, "channelFactory");
        this.channel = Objects.requireNonNull(channel, "channel");
        this.sessionPromise = Objects.requireNonNull(sessionPromise, "sessionPromise");
        this.sessionTimeoutFuture = Objects.requireNonNull(sessionTimeoutFuture, "sessionTimeoutFuture");
    }

    @Override
    public SessionProtocol protocol() {
        return this.protocol;
    }

    @Override
    public InboundTrafficController inboundTrafficController() {
        return this.responseDecoder.inboundTrafficController();
    }

    @Override
    public boolean hasUnfinishedResponses() {
        return this.responseDecoder.hasUnfinishedResponses();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean invoke(ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        SessionProtocol sessionProtocol = this.protocol();
        if (sessionProtocol == null) {
            res.close((Throwable)ClosedSessionException.get());
            return false;
        }
        long writeTimeoutMillis = ctx.writeTimeoutMillis();
        long responseTimeoutMillis = ctx.responseTimeoutMillis();
        long maxContentLength = ctx.maxResponseLength();
        int numRequestsSent = ++this.numRequestsSent;
        this.responseDecoder.addResponse(numRequestsSent, res, ctx.responseLogBuilder(), responseTimeoutMillis, maxContentLength);
        req.subscribe((Subscriber)new HttpRequestSubscriber(this.channel, this.requestEncoder, numRequestsSent, req.headers(), (HttpResponseWriter)res, ctx.requestLogBuilder(), writeTimeoutMillis), (Executor)this.channel.eventLoop());
        if (numRequestsSent >= 0x20000000) {
            this.responseDecoder.disconnectWhenFinished();
            return false;
        }
        return true;
    }

    @Override
    public void retryWithH1C() {
        this.needsRetryWithH1C = true;
    }

    @Override
    public void deactivate() {
        this.active = false;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.active = ctx.channel().isActive();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.active = true;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof Http2Settings)) {
            try {
                String typeInfo = msg instanceof ByteBuf ? msg + " HexDump: " + ByteBufUtil.hexDump((ByteBuf)((ByteBuf)msg)) : String.valueOf(msg);
                throw new IllegalStateException("unexpected message type: " + typeInfo);
            }
            catch (Throwable throwable) {
                ReferenceCountUtil.release((Object)msg);
                throw throwable;
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SessionProtocol) {
            SessionProtocol protocol;
            assert (this.protocol == null);
            assert (this.responseDecoder == null);
            this.sessionTimeoutFuture.cancel(false);
            this.protocol = protocol = (SessionProtocol)evt;
            switch (protocol) {
                case H1: 
                case H1C: {
                    this.requestEncoder = new Http1ObjectEncoder(false);
                    this.responseDecoder = (HttpResponseDecoder)ctx.pipeline().get(Http1ResponseDecoder.class);
                    break;
                }
                case H2: 
                case H2C: {
                    Http2ConnectionHandler handler = (Http2ConnectionHandler)ctx.pipeline().get(Http2ConnectionHandler.class);
                    this.requestEncoder = new Http2ObjectEncoder(handler.encoder());
                    this.responseDecoder = ((Http2ClientConnectionHandler)ctx.pipeline().get(Http2ClientConnectionHandler.class)).responseDecoder();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            if (!this.sessionPromise.trySuccess((Object)ctx.channel())) {
                ctx.close();
            }
            return;
        }
        if (evt instanceof SessionProtocolNegotiationException) {
            this.sessionTimeoutFuture.cancel(false);
            this.sessionPromise.tryFailure((Throwable)((SessionProtocolNegotiationException)evt));
            ctx.close();
            return;
        }
        logger.log(Level.WARNING, MessageFormat.format("{0} Unexpected user event", ctx.channel()), evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.active = false;
        if (this.needsRetryWithH1C) {
            assert (this.responseDecoder == null || !this.responseDecoder.hasUnfinishedResponses());
            this.sessionTimeoutFuture.cancel(false);
            this.channelFactory.connect(ctx.channel().remoteAddress(), SessionProtocol.H1C, this.sessionPromise);
        } else {
            this.failUnfinishedResponses((Throwable)ClosedSessionException.get());
            this.sessionTimeoutFuture.cancel(false);
            this.sessionPromise.tryFailure((Throwable)ClosedSessionException.get());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Exceptions.logIfUnexpected((Logger)logger, (Channel)ctx.channel(), (SessionProtocol)this.protocol(), (Throwable)cause);
        if (ctx.channel().isActive()) {
            ctx.close();
        }
    }

    private void failUnfinishedResponses(Throwable e) {
        HttpResponseDecoder responseDecoder = this.responseDecoder;
        if (responseDecoder == null) {
            return;
        }
        responseDecoder.failUnfinishedResponses(e);
    }
}

