/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.xbib.helianthus.client.http.SimpleHttpRequest;

@Deprecated
public class SimpleHttpRequestBuilder {
    private static final byte[] EMPTY = new byte[0];
    private final URI uri;
    private final HttpMethod method;
    private HttpHeaders headers = EmptyHttpHeaders.INSTANCE;
    private byte[] content = EMPTY;

    private SimpleHttpRequestBuilder(URI uri, HttpMethod method) {
        this.uri = uri;
        this.method = method;
    }

    public static SimpleHttpRequestBuilder forGet(String uri) {
        return SimpleHttpRequestBuilder.createRequestBuilder(uri, HttpMethod.GET);
    }

    public static SimpleHttpRequestBuilder forPost(String uri) {
        return SimpleHttpRequestBuilder.createRequestBuilder(uri, HttpMethod.POST);
    }

    public static SimpleHttpRequestBuilder forPut(String uri) {
        return SimpleHttpRequestBuilder.createRequestBuilder(uri, HttpMethod.PUT);
    }

    public static SimpleHttpRequestBuilder forPatch(String uri) {
        return SimpleHttpRequestBuilder.createRequestBuilder(uri, HttpMethod.PATCH);
    }

    public static SimpleHttpRequestBuilder forDelete(String uri) {
        return SimpleHttpRequestBuilder.createRequestBuilder(uri, HttpMethod.DELETE);
    }

    public static SimpleHttpRequestBuilder forHead(String uri) {
        return SimpleHttpRequestBuilder.createRequestBuilder(uri, HttpMethod.HEAD);
    }

    public static SimpleHttpRequestBuilder forOptions(String uri) {
        return SimpleHttpRequestBuilder.createRequestBuilder(uri, HttpMethod.OPTIONS);
    }

    private static SimpleHttpRequestBuilder createRequestBuilder(String uri, HttpMethod method) {
        Objects.requireNonNull(uri);
        try {
            return new SimpleHttpRequestBuilder(new URI(uri), method);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid uri: " + uri, e);
        }
    }

    public SimpleHttpRequestBuilder header(CharSequence name, Object value) {
        this.headers().add(Objects.requireNonNull(name, "name"), Objects.requireNonNull(value, "value"));
        return this;
    }

    public SimpleHttpRequestBuilder headers(HttpHeaders headers) {
        this.headers().add(Objects.requireNonNull(headers));
        return this;
    }

    private HttpHeaders headers() {
        if (this.headers == EmptyHttpHeaders.INSTANCE) {
            this.headers = new DefaultHttpHeaders();
        }
        return this.headers;
    }

    public SimpleHttpRequestBuilder content(byte[] bytes) {
        this.content = bytes;
        return this;
    }

    public SimpleHttpRequestBuilder content(String chars, Charset charset) {
        return this.content(chars.getBytes(charset));
    }

    public SimpleHttpRequest build() {
        return new SimpleHttpRequest(this.uri, this.method, this.headers, this.content);
    }

    public String toString() {
        return SimpleHttpRequest.toString(this.uri, this.method, this.headers, this.content);
    }
}

