package org.xbib.helianthus.client.http;

import io.netty.util.AsciiString;

final class HttpHeaderUtil {

    static final AsciiString USER_AGENT = AsciiString.of("Helianthus");

    private HttpHeaderUtil() {
    }

    static String hostHeader(String host, int port, int defaultPort) {
        if (port == defaultPort) {
            return host;
        }

        return new StringBuilder(host.length() + 6).append(host).append(':').append(port).toString();
    }
}
