package org.xbib.helianthus.client.pool;

import static java.util.Objects.requireNonNull;

import io.netty.channel.Channel;

/**
 * A {@link KeyedChannelPoolHandler} that decorates an existing {@link KeyedChannelPoolHandler}.
 */
public class DecoratingKeyedChannelPoolHandler<K> implements KeyedChannelPoolHandler<K> {

    private final KeyedChannelPoolHandler<K> delegate;

    /**
     * Creates a new decorator with the specified {@code delegate}.
     */
    protected DecoratingKeyedChannelPoolHandler(KeyedChannelPoolHandler<K> delegate) {
        this.delegate = requireNonNull(delegate, "delegate");
    }

    /**
     * Returns the {@link KeyedChannelPoolHandler} this handler decorates.
     */
    @SuppressWarnings("unchecked")
    protected <T extends KeyedChannelPoolHandler<K>> T delegate() {
        return (T) delegate;
    }

    @Override
    public void channelReleased(K key, Channel ch) throws Exception {
        delegate().channelReleased(key, ch);
    }

    @Override
    public void channelAcquired(K key, Channel ch) throws Exception {
        delegate().channelAcquired(key, ch);
    }

    @Override
    public void channelCreated(K key, Channel ch) throws Exception {
        delegate().channelCreated(key, ch);
    }

    @Override
    public void channelClosed(K key, Channel ch) throws Exception {
        delegate().channelClosed(key, ch);
    }
}
