package org.xbib.helianthus.client.routing;

import static java.util.Objects.requireNonNull;

import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.common.util.ImmutableList;

import java.util.List;

public final class StaticEndpointGroup implements EndpointGroup {

    private final List<Endpoint> endpoints;

    @SuppressWarnings("unchecked")
    public StaticEndpointGroup(Iterable<Endpoint> endpoints) {
        requireNonNull(endpoints, "endpoints");
        this.endpoints = new ImmutableList<>(endpoints);
    }

    @Override
    public List<Endpoint> endpoints() {
        return endpoints;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("StaticEndpointGroup(");
        for (Endpoint endpoint : endpoints) {
            buf.append(endpoint).append(',');
        }
        buf.setCharAt(buf.length() - 1, ')');

        return buf.toString();
    }
}
