/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.xbib.helianthus.client.ClientFactory;
import org.xbib.helianthus.client.ClientOptionValue;
import org.xbib.helianthus.client.ClientOptions;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.common.Scheme;

public abstract class AbstractClientFactory
implements ClientFactory {
    protected AbstractClientFactory() {
    }

    protected static Endpoint newEndpoint(URI uri) {
        return Endpoint.parse(uri.getAuthority());
    }

    @Override
    public final <T> T newClient(String uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(options, "options");
        return this.newClient(URI.create(uri), clientType, ClientOptions.of(options));
    }

    @Override
    public final <T> T newClient(String uri, Class<T> clientType, ClientOptions options) {
        Objects.requireNonNull(uri, "uri");
        return this.newClient(URI.create(uri), clientType, options);
    }

    @Override
    public final <T> T newClient(URI uri, Class<T> clientType, ClientOptionValue<?> ... options) {
        Objects.requireNonNull(options, "options");
        return this.newClient(uri, clientType, ClientOptions.of(options));
    }

    protected final Scheme validate(URI uri, Class<?> clientType, ClientOptions options) {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(clientType, "clientType");
        Objects.requireNonNull(options, "options");
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("URI with missing scheme: " + uri);
        }
        if (uri.getAuthority() == null) {
            throw new IllegalArgumentException("URI with missing authority: " + uri);
        }
        Optional parsedSchemeOpt = Scheme.tryParse((String)scheme);
        if (!parsedSchemeOpt.isPresent()) {
            throw new IllegalArgumentException("URI with unknown scheme: " + uri);
        }
        Scheme parsedScheme = (Scheme)parsedSchemeOpt.get();
        Set<Scheme> supportedSchemes = this.supportedSchemes();
        if (!supportedSchemes.contains(parsedScheme)) {
            throw new IllegalArgumentException("URI with unsupported scheme: " + uri + " (expected: " + supportedSchemes + ')');
        }
        return parsedScheme;
    }
}

