/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.xbib.helianthus.client.ClientFactory;
import org.xbib.helianthus.client.ClientOptions;
import org.xbib.helianthus.client.NonDecoratingClientFactory;
import org.xbib.helianthus.client.SessionOptions;
import org.xbib.helianthus.client.http.HttpClientFactory;
import org.xbib.helianthus.common.Scheme;
import org.xbib.helianthus.common.util.ImmutableMap;

public class AllInOneClientFactory
extends NonDecoratingClientFactory {
    private static final Logger logger = Logger.getLogger(AllInOneClientFactory.class.getName());
    private final Map<Scheme, ClientFactory> clientFactories;

    public AllInOneClientFactory() {
        this(SessionOptions.DEFAULT, false);
    }

    public AllInOneClientFactory(SessionOptions options, boolean useDaemonThreads) {
        super(options, useDaemonThreads);
        HttpClientFactory httpClientFactory = new HttpClientFactory(options, useDaemonThreads);
        HashMap map = new HashMap();
        for (ClientFactory clientFactory : Collections.singletonList(httpClientFactory)) {
            clientFactory.supportedSchemes().forEach(s -> map.put(s, f));
        }
        this.clientFactories = new ImmutableMap(map);
    }

    @Override
    public Set<Scheme> supportedSchemes() {
        return this.clientFactories.keySet();
    }

    @Override
    public <T> T newClient(URI uri, Class<T> clientType, ClientOptions options) {
        Scheme scheme = this.validate(uri, clientType, options);
        return this.clientFactories.get(scheme).newClient(uri, clientType, options);
    }

    @Override
    public void close() {
        if (this == ClientFactory.DEFAULT) {
            logger.fine(MessageFormat.format("Refusing to close the default {0}; must be closed via closeDefault()", ClientFactory.class.getSimpleName()));
            return;
        }
        this.doClose();
    }

    void doClose() {
        this.clientFactories.values().forEach(ClientFactory::close);
    }

    static {
        if (AllInOneClientFactory.class.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            Runtime.getRuntime().addShutdownHook(new Thread(ClientFactory::closeDefault));
        }
    }
}

