/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import java.net.URI;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.xbib.helianthus.client.Client;
import org.xbib.helianthus.client.ClientDecorationBuilder;
import org.xbib.helianthus.client.ClientFactory;
import org.xbib.helianthus.client.ClientOption;
import org.xbib.helianthus.client.ClientOptionValue;
import org.xbib.helianthus.client.ClientOptions;
import org.xbib.helianthus.common.Request;
import org.xbib.helianthus.common.Response;

public final class ClientBuilder {
    private final URI uri;
    private final Map<ClientOption<?>, ClientOptionValue<?>> options = new LinkedHashMap();
    private ClientFactory factory = ClientFactory.DEFAULT;
    private ClientDecorationBuilder decoration;

    public ClientBuilder(String uri) {
        this(URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public ClientBuilder(URI uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
    }

    public ClientBuilder factory(ClientFactory factory) {
        this.factory = Objects.requireNonNull(factory, "factory");
        return this;
    }

    public ClientBuilder options(ClientOptions options) {
        Objects.requireNonNull(options, "options");
        Map<ClientOption<Object>, ClientOptionValue<Object>> optionMap = options.asMap();
        for (ClientOptionValue<Object> o : optionMap.values()) {
            this.validateOption((ClientOption)o.option());
        }
        this.options.putAll(optionMap);
        return this;
    }

    public ClientBuilder options(ClientOptionValue<?> ... options) {
        Objects.requireNonNull(options, "options");
        for (int i = 0; i < options.length; ++i) {
            ClientOptionValue<?> o = options[i];
            if (o == null) {
                throw new NullPointerException("options[" + i + ']');
            }
            if (o.option() == ClientOption.DECORATION && this.decoration != null) {
                throw new IllegalArgumentException("options[" + i + "]: option(" + ClientOption.DECORATION + ") and decorator() are mutually exclusive.");
            }
            this.options.put((ClientOption<?>)o.option(), o);
        }
        return this;
    }

    public <T> ClientBuilder option(ClientOption<T> option, T value) {
        this.validateOption(option);
        this.options.put(option, option.newValue(value));
        return this;
    }

    private void validateOption(ClientOption<?> option) {
        Objects.requireNonNull(option, "option");
        if (option == ClientOption.DECORATION && this.decoration != null) {
            throw new IllegalArgumentException("option(" + ClientOption.DECORATION + ") and decorator() are mutually exclusive.");
        }
    }

    public ClientBuilder defaultWriteTimeoutMillis(long defaultWriteTimeoutMillis) {
        return this.option(ClientOption.DEFAULT_WRITE_TIMEOUT_MILLIS, defaultWriteTimeoutMillis);
    }

    public ClientBuilder defaultWriteTimeout(Duration defaultWriteTimeout) {
        return this.defaultWriteTimeoutMillis(Objects.requireNonNull(defaultWriteTimeout, "defaultWriteTimeout").toMillis());
    }

    public ClientBuilder defaultResponseTimeoutMillis(long defaultResponseTimeoutMillis) {
        return this.option(ClientOption.DEFAULT_RESPONSE_TIMEOUT_MILLIS, defaultResponseTimeoutMillis);
    }

    public ClientBuilder defaultResponseTimeout(Duration defaultResponseTimeout) {
        return this.defaultResponseTimeoutMillis(Objects.requireNonNull(defaultResponseTimeout, "defaultResponseTimeout").toMillis());
    }

    public <T extends Client<? super I, ? extends O>, R extends Client<I, O>, I extends Request, O extends Response> ClientBuilder decorator(Class<I> requestType, Class<O> responseType, Function<T, R> decorator) {
        if (this.options.containsKey(ClientOption.DECORATION)) {
            throw new IllegalArgumentException("decorator() and option(" + ClientOption.DECORATION + ") are mutually exclusive.");
        }
        if (this.decoration == null) {
            this.decoration = new ClientDecorationBuilder();
        }
        this.decoration.add(requestType, responseType, decorator);
        return this;
    }

    public <T> T build(Class<T> clientType) {
        Objects.requireNonNull(clientType, "clientType");
        if (this.decoration != null) {
            this.options.put(ClientOption.DECORATION, ClientOption.DECORATION.newValue(this.decoration.build()));
        }
        return this.factory.newClient(this.uri, clientType, ClientOptions.of(this.options.values()));
    }
}

