/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.Headers;
import java.time.Duration;
import java.util.Objects;
import org.xbib.helianthus.client.ClientOption;
import org.xbib.helianthus.client.ClientOptions;
import org.xbib.helianthus.client.ClientRequestContext;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.common.NonWrappingRequestContext;
import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.DefaultHttpHeaders;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.logging.DefaultRequestLog;
import org.xbib.helianthus.common.logging.RequestLog;
import org.xbib.helianthus.common.logging.RequestLogAvailability;
import org.xbib.helianthus.common.logging.RequestLogBuilder;

public final class DefaultClientRequestContext
extends NonWrappingRequestContext
implements ClientRequestContext {
    private final EventLoop eventLoop;
    private final ClientOptions options;
    private final Endpoint endpoint;
    private final String fragment;
    private final DefaultRequestLog log;
    private long writeTimeoutMillis;
    private long responseTimeoutMillis;
    private long maxResponseLength;
    private String strVal;

    public DefaultClientRequestContext(EventLoop eventLoop, SessionProtocol sessionProtocol, Endpoint endpoint, String method, String path, String fragment, ClientOptions options, Object request) {
        super(sessionProtocol, method, path, request);
        HttpHeaders headers;
        this.eventLoop = eventLoop;
        this.options = options;
        this.endpoint = endpoint;
        this.fragment = Objects.requireNonNull(fragment, "fragment");
        this.log = new DefaultRequestLog((RequestContext)this);
        this.writeTimeoutMillis = options.defaultWriteTimeoutMillis();
        this.responseTimeoutMillis = options.defaultResponseTimeoutMillis();
        this.maxResponseLength = options.defaultMaxResponseLength();
        if (SessionProtocol.ofHttp().contains(sessionProtocol) && !(headers = options.getOrElse(ClientOption.HTTP_HEADERS, HttpHeaders.EMPTY_HEADERS)).isEmpty()) {
            DefaultHttpHeaders headersCopy = new DefaultHttpHeaders(true, headers.size());
            headersCopy.set((Headers)headers);
            this.attr(HTTP_HEADERS).set((Object)headersCopy);
        }
    }

    protected Channel channel() {
        if (this.log.isAvailable(RequestLogAvailability.REQUEST_START)) {
            return this.log.channel();
        }
        return null;
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @Override
    public ClientOptions options() {
        return this.options;
    }

    @Override
    public Endpoint endpoint() {
        return this.endpoint;
    }

    @Override
    public String fragment() {
        return this.fragment;
    }

    @Override
    public long writeTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    @Override
    public void setWriteTimeoutMillis(long writeTimeoutMillis) {
        if (writeTimeoutMillis < 0L) {
            throw new IllegalArgumentException("writeTimeoutMillis: " + writeTimeoutMillis + " (expected: >= 0)");
        }
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    @Override
    public void setWriteTimeout(Duration writeTimeout) {
        this.setWriteTimeoutMillis(Objects.requireNonNull(writeTimeout, "writeTimeout").toMillis());
    }

    @Override
    public long responseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    @Override
    public void setResponseTimeoutMillis(long responseTimeoutMillis) {
        if (responseTimeoutMillis < 0L) {
            throw new IllegalArgumentException("responseTimeoutMillis: " + responseTimeoutMillis + " (expected: >= 0)");
        }
        this.responseTimeoutMillis = responseTimeoutMillis;
    }

    @Override
    public void setResponseTimeout(Duration responseTimeout) {
        this.setResponseTimeoutMillis(Objects.requireNonNull(responseTimeout, "responseTimeout").toMillis());
    }

    @Override
    public long maxResponseLength() {
        return this.maxResponseLength;
    }

    @Override
    public void setMaxResponseLength(long maxResponseLength) {
        this.maxResponseLength = maxResponseLength;
    }

    public RequestLog log() {
        return this.log;
    }

    public RequestLogBuilder logBuilder() {
        return this.log;
    }

    public String toString() {
        boolean hasChannel;
        String strVal = this.strVal;
        if (strVal != null) {
            return strVal;
        }
        StringBuilder buf = new StringBuilder(96);
        Channel ch = this.channel();
        boolean bl = hasChannel = ch != null;
        if (hasChannel) {
            buf.append(ch);
        }
        buf.append('[').append(this.sessionProtocol().uriText()).append("://").append(this.endpoint.authority()).append(this.path()).append('#').append(this.method()).append(']');
        strVal = buf.toString();
        if (hasChannel) {
            this.strVal = strVal;
        }
        return strVal;
    }
}

