/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.channel.EventLoop;
import org.xbib.helianthus.client.Client;
import org.xbib.helianthus.client.ClientBuilderParams;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.client.UserClient;
import org.xbib.helianthus.client.http.HttpClient;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.AggregatedHttpMessage;
import org.xbib.helianthus.common.http.DefaultHttpRequest;
import org.xbib.helianthus.common.http.DefaultHttpResponse;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaderNames;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpRequest;
import org.xbib.helianthus.common.http.HttpResponse;

final class DefaultHttpClient
extends UserClient<HttpRequest, HttpResponse>
implements HttpClient {
    DefaultHttpClient(ClientBuilderParams params, Client<HttpRequest, HttpResponse> delegate, SessionProtocol sessionProtocol, Endpoint endpoint) {
        super(params, delegate, sessionProtocol, endpoint);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        return this.execute(this.eventLoop(), req);
    }

    private HttpResponse execute(EventLoop eventLoop, HttpRequest req) {
        return this.execute(eventLoop, req.method().name(), req.path(), "", req, cause -> {
            DefaultHttpResponse res = new DefaultHttpResponse();
            res.close(cause);
            return res;
        });
    }

    @Override
    public HttpResponse execute(AggregatedHttpMessage aggregatedReq) {
        return this.execute(this.eventLoop(), aggregatedReq);
    }

    private HttpResponse execute(EventLoop eventLoop, AggregatedHttpMessage aggregatedReq) {
        HttpHeaders trailingHeaders;
        HttpHeaders headers = aggregatedReq.headers();
        DefaultHttpRequest req = new DefaultHttpRequest(headers);
        HttpData content = aggregatedReq.content();
        if (!content.isEmpty()) {
            headers.setInt((Object)HttpHeaderNames.CONTENT_LENGTH, content.length());
            req.write((Object)content);
        }
        if (!(trailingHeaders = aggregatedReq.trailingHeaders()).isEmpty()) {
            req.write((Object)trailingHeaders);
        }
        req.close();
        return this.execute(eventLoop, (HttpRequest)req);
    }

    public static HttpClient newInstance(ClientBuilderParams params, Client<HttpRequest, HttpResponse> delegate, SessionProtocol sessionProtocol, Endpoint endpoint) {
        return new DefaultHttpClient(params, delegate, sessionProtocol, endpoint);
    }
}

