/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import java.util.logging.Logger;
import org.xbib.helianthus.client.http.HttpResponseDecoder;
import org.xbib.helianthus.common.ClosedSessionException;
import org.xbib.helianthus.common.ContentTooLargeException;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.internal.http.HelianthusHttpUtil;

final class Http2ResponseDecoder
extends HttpResponseDecoder
implements Http2Connection.Listener,
Http2FrameListener {
    private static final Logger logger = Logger.getLogger(Http2ResponseDecoder.class.getName());
    private final Http2Connection conn;

    Http2ResponseDecoder(Http2Connection conn, Channel channel) {
        super(channel);
        this.conn = conn;
    }

    public void onStreamAdded(Http2Stream stream) {
    }

    public void onStreamActive(Http2Stream stream) {
    }

    public void onStreamHalfClosed(Http2Stream stream) {
    }

    public void onStreamClosed(Http2Stream stream) {
    }

    public void onStreamRemoved(Http2Stream stream) {
    }

    public void onPriorityTreeParentChanged(Http2Stream stream, Http2Stream oldParent) {
    }

    public void onPriorityTreeParentChanging(Http2Stream stream, Http2Stream newParent) {
    }

    public void onWeightChanged(Http2Stream stream, short oldWeight) {
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
        ctx.fireChannelRead((Object)settings);
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) {
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        HttpResponseDecoder.HttpResponseWrapper res = this.getResponse(Http2ResponseDecoder.id(streamId), endOfStream);
        if (res == null) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a HEADERS frame for an unknown stream: %d", (Object[])new Object[]{streamId});
        }
        HttpHeaders converted = HelianthusHttpUtil.toHelianthus((Http2Headers)headers);
        try {
            res.scheduleTimeout(ctx);
            res.write((HttpObject)converted);
        }
        catch (Throwable t) {
            res.close(t);
            throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)t, (String)"failed to consume a HEADERS frame", (Object[])new Object[0]);
        }
        if (endOfStream) {
            res.close();
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        HttpResponseDecoder.HttpResponseWrapper res = this.getResponse(Http2ResponseDecoder.id(streamId), endOfStream);
        if (res == null) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a DATA frame for an unknown stream: %d", (Object[])new Object[]{streamId});
        }
        int dataLength = data.readableBytes();
        long maxContentLength = res.maxContentLength();
        if (maxContentLength > 0L && res.writtenBytes() > maxContentLength - (long)dataLength) {
            res.close((Throwable)ContentTooLargeException.get());
            throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (String)"content length too large: %d + %d > %d (stream: %d)", (Object[])new Object[]{res.writtenBytes(), dataLength, maxContentLength, streamId});
        }
        try {
            res.write((HttpObject)HttpData.of((ByteBuf)data));
        }
        catch (Throwable t) {
            res.close(t);
            throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)t, (String)"failed to consume a DATA frame", (Object[])new Object[0]);
        }
        if (endOfStream) {
            res.close();
        }
        return dataLength + padding;
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        HttpResponseDecoder.HttpResponseWrapper res = this.removeResponse(Http2ResponseDecoder.id(streamId));
        if (res == null) {
            if (!this.conn.streamMayHaveExisted(streamId)) {
                throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a RST_STREAM frame for an unknown stream: %d", (Object[])new Object[]{streamId});
            }
            return;
        }
        res.close((Throwable)ClosedSessionException.get());
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    public void onPingRead(ChannelHandlerContext ctx, ByteBuf data) {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }

    private static int id(int streamId) {
        return streamId - 1 >>> 1;
    }
}

