/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.xbib.helianthus.client.Client;
import org.xbib.helianthus.client.ClientRequestContext;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.client.SessionOptions;
import org.xbib.helianthus.client.http.DecodedHttpResponse;
import org.xbib.helianthus.client.http.HttpClientFactory;
import org.xbib.helianthus.client.http.HttpHeaderUtil;
import org.xbib.helianthus.client.http.HttpSession;
import org.xbib.helianthus.client.http.HttpSessionChannelFactory;
import org.xbib.helianthus.client.pool.DefaultKeyedChannelPool;
import org.xbib.helianthus.client.pool.KeyedChannelPool;
import org.xbib.helianthus.client.pool.KeyedChannelPoolHandler;
import org.xbib.helianthus.client.pool.KeyedChannelPoolHandlerAdapter;
import org.xbib.helianthus.client.pool.PoolKey;
import org.xbib.helianthus.common.ClosedSessionException;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.HttpHeaderNames;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpRequest;
import org.xbib.helianthus.common.http.HttpResponse;
import org.xbib.helianthus.common.util.CompletionActions;

final class HttpClientDelegate
implements Client<HttpRequest, HttpResponse> {
    private static final KeyedChannelPoolHandlerAdapter<PoolKey> NOOP_POOL_HANDLER = new KeyedChannelPoolHandlerAdapter();
    private static final ChannelHealthChecker POOL_HEALTH_CHECKER = ch -> ch.eventLoop().newSucceededFuture((Object)HttpSession.get(ch).isActive());
    private final ConcurrentMap<EventLoop, KeyedChannelPool<PoolKey>> map = new ConcurrentHashMap<EventLoop, KeyedChannelPool<PoolKey>>();
    private final HttpClientFactory factory;

    HttpClientDelegate(HttpClientFactory factory) {
        this.factory = Objects.requireNonNull(factory, "factory");
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        Endpoint endpoint = ctx.endpoint().resolve().withDefaultPort(ctx.sessionProtocol().defaultPort());
        HttpClientDelegate.autoFillHeaders(ctx, endpoint, req);
        PoolKey poolKey = new PoolKey(InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port()), ctx.sessionProtocol());
        EventLoop eventLoop = ctx.eventLoop();
        Future<Channel> channelFuture = this.pool(eventLoop).acquire(poolKey);
        DecodedHttpResponse res = new DecodedHttpResponse(eventLoop);
        if (channelFuture.isDone()) {
            if (channelFuture.isSuccess()) {
                Channel ch = (Channel)channelFuture.getNow();
                this.invoke0(ch, ctx, req, res, poolKey);
            } else {
                res.close(channelFuture.cause());
            }
        } else {
            channelFuture.addListener(future -> {
                if (future.isSuccess()) {
                    Channel ch = (Channel)future.getNow();
                    this.invoke0(ch, ctx, req, res, poolKey);
                } else {
                    res.close(channelFuture.cause());
                }
            });
        }
        return res;
    }

    private static void autoFillHeaders(ClientRequestContext ctx, Endpoint endpoint, HttpRequest req) {
        Objects.requireNonNull(req, "req");
        HttpHeaders headers = req.headers();
        if (headers.authority() == null) {
            String hostname = endpoint.host();
            int port = endpoint.port();
            String authority = port == ctx.sessionProtocol().defaultPort() ? hostname : hostname + ':' + port;
            headers.authority(authority);
        }
        if (headers.scheme() == null) {
            headers.scheme(ctx.sessionProtocol().isTls() ? "https" : "http");
        }
        if (ctx.hasAttr(ClientRequestContext.HTTP_HEADERS)) {
            HttpHeaders clientOptionHeaders = (HttpHeaders)ctx.attr(ClientRequestContext.HTTP_HEADERS).get();
            clientOptionHeaders.forEach(entry -> {
                AsciiString name = (AsciiString)entry.getKey();
                if (!headers.contains((Object)name)) {
                    headers.set((Object)name, entry.getValue());
                }
            });
        }
        if (!headers.contains((Object)HttpHeaderNames.USER_AGENT)) {
            headers.set((Object)HttpHeaderNames.USER_AGENT, (Object)HttpHeaderUtil.USER_AGENT.toString());
        }
    }

    private KeyedChannelPool<PoolKey> pool(EventLoop eventLoop) {
        KeyedChannelPool pool = (KeyedChannelPool)this.map.get(eventLoop);
        if (pool != null) {
            return pool;
        }
        return this.map.computeIfAbsent(eventLoop, e -> {
            Bootstrap bootstrap = this.factory.newBootstrap();
            SessionOptions options = this.factory.options();
            bootstrap.group((EventLoopGroup)eventLoop);
            HttpSessionChannelFactory factory = new HttpSessionChannelFactory(bootstrap, options);
            KeyedChannelPoolHandler<PoolKey> handler = options.poolHandlerDecorator().apply(NOOP_POOL_HANDLER);
            DefaultKeyedChannelPool<PoolKey> newPool = new DefaultKeyedChannelPool<PoolKey>(eventLoop, factory, POOL_HEALTH_CHECKER, handler, true);
            eventLoop.terminationFuture().addListener((GenericFutureListener)((FutureListener)f -> {
                this.map.remove(eventLoop);
                newPool.close();
            }));
            return newPool;
        });
    }

    private void invoke0(Channel channel, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res, PoolKey poolKey) {
        HttpSession session = HttpSession.get(channel);
        res.init(session.inboundTrafficController());
        SessionProtocol sessionProtocol = session.protocol();
        if (sessionProtocol == null) {
            res.close((Throwable)ClosedSessionException.get());
            return;
        }
        if (session.invoke(ctx, req, res)) {
            KeyedChannelPool<PoolKey> pool = KeyedChannelPool.findPool(channel);
            if (sessionProtocol.isMultiplex()) {
                pool.release(poolKey, channel);
            } else {
                ((CompletableFuture)req.closeFuture().handle((ret, cause) -> pool.release(poolKey, channel))).exceptionally(CompletionActions::log);
            }
        }
    }

    void close() {
        this.map.values().forEach(KeyedChannelPool::close);
    }
}

