/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.xbib.helianthus.client.SessionOptions;
import org.xbib.helianthus.client.SessionProtocolNegotiationCache;
import org.xbib.helianthus.client.SessionProtocolNegotiationException;
import org.xbib.helianthus.client.http.DecodedHttpResponse;
import org.xbib.helianthus.client.http.Http1ResponseDecoder;
import org.xbib.helianthus.client.http.Http2ClientConnectionHandler;
import org.xbib.helianthus.client.http.Http2ResponseDecoder;
import org.xbib.helianthus.client.http.HttpClientIdleTimeoutHandler;
import org.xbib.helianthus.client.http.HttpHeaderUtil;
import org.xbib.helianthus.client.http.HttpSession;
import org.xbib.helianthus.client.http.HttpSessionHandler;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.common.logging.RequestLogBuilder;
import org.xbib.helianthus.common.util.Exceptions;
import org.xbib.helianthus.common.util.NativeLibraries;
import org.xbib.helianthus.internal.FlushConsolidationHandler;
import org.xbib.helianthus.internal.ReadSuppressingHandler;
import org.xbib.helianthus.internal.TrafficLoggingHandler;
import org.xbib.helianthus.internal.http.Http1ClientCodec;
import org.xbib.helianthus.internal.http.Http2GoAwayListener;

class HttpClientPipelineConfigurator
extends ChannelDuplexHandler {
    private static final Logger logger = Logger.getLogger(HttpClientPipelineConfigurator.class.getName());
    private static final long UPGRADE_RESPONSE_MAX_LENGTH = 16384L;
    private final SslContext sslCtx;
    private final HttpPreference httpPreference;
    private final SessionOptions options;
    private InetSocketAddress remoteAddress;

    HttpClientPipelineConfigurator(SessionProtocol sessionProtocol, SessionOptions options) {
        switch (sessionProtocol) {
            case HTTP: 
            case HTTPS: {
                this.httpPreference = HttpPreference.HTTP2_PREFERRED;
                break;
            }
            case H1: 
            case H1C: {
                this.httpPreference = HttpPreference.HTTP1_REQUIRED;
                break;
            }
            case H2: 
            case H2C: {
                this.httpPreference = HttpPreference.HTTP2_REQUIRED;
                break;
            }
            default: {
                throw new Error();
            }
        }
        this.options = Objects.requireNonNull(options, "options");
        if (sessionProtocol.isTls()) {
            try {
                SslContextBuilder builder = SslContextBuilder.forClient();
                builder.sslProvider(NativeLibraries.isOpenSslAvailable() ? SslProvider.OPENSSL : SslProvider.JDK);
                options.trustManagerFactory().ifPresent(arg_0 -> ((SslContextBuilder)builder).trustManager(arg_0));
                if (this.httpPreference == HttpPreference.HTTP2_REQUIRED || this.httpPreference == HttpPreference.HTTP2_PREFERRED) {
                    builder.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"}));
                }
                this.sslCtx = builder.build();
            }
            catch (SSLException e) {
                throw new IllegalStateException("failed to create an SslContext", e);
            }
        } else {
            this.sslCtx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.remoteAddress = (InetSocketAddress)remoteAddress;
        Channel ch = ctx.channel();
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new FlushConsolidationHandler()});
        p.addLast(new ChannelHandler[]{ReadSuppressingHandler.INSTANCE});
        try {
            if (this.sslCtx != null) {
                this.configureAsHttps(ch);
            } else {
                this.configureAsHttp(ch);
            }
        }
        catch (Throwable t) {
            promise.tryFailure(t);
            ctx.close();
        }
        finally {
            if (p.context((ChannelHandler)this) != null) {
                p.remove((ChannelHandler)this);
            }
        }
        ctx.connect(remoteAddress, localAddress, promise);
    }

    private void configureAsHttps(final Channel ch) {
        final ChannelPipeline p = ch.pipeline();
        final SslHandler sslHandler = this.sslCtx.newHandler(ch.alloc());
        p.addLast(new ChannelHandler[]{sslHandler});
        p.addLast(new ChannelHandler[]{TrafficLoggingHandler.CLIENT});
        p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                SessionProtocol protocol;
                if (!(evt instanceof SslHandshakeCompletionEvent)) {
                    ctx.fireUserEventTriggered(evt);
                    return;
                }
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (!handshakeEvent.isSuccess()) {
                    return;
                }
                if (HttpClientPipelineConfigurator.this.isHttp2Protocol(sslHandler)) {
                    if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP1_REQUIRED) {
                        HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H1, SessionProtocol.H2, "unexpected protocol negotiation result");
                        return;
                    }
                    HttpClientPipelineConfigurator.this.addBeforeSessionHandler(p, (ChannelHandler)HttpClientPipelineConfigurator.this.newHttp2ConnectionHandler(ch));
                    protocol = SessionProtocol.H2;
                } else {
                    if (HttpClientPipelineConfigurator.this.httpPreference != HttpPreference.HTTP1_REQUIRED) {
                        SessionProtocolNegotiationCache.setUnsupported(ctx.channel().remoteAddress(), SessionProtocol.H2);
                    }
                    if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                        HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2, SessionProtocol.H1, "unexpected protocol negotiation result");
                        return;
                    }
                    HttpClientPipelineConfigurator.this.addBeforeSessionHandler(p, (ChannelHandler)HttpClientPipelineConfigurator.newHttp1Codec());
                    protocol = SessionProtocol.H1;
                }
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, protocol);
                p.remove((ChannelHandler)this);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                Exceptions.logIfUnexpected((Logger)logger, (Channel)ctx.channel(), (Throwable)cause);
                ctx.close();
            }
        }});
    }

    private void configureAsHttp(Channel ch) {
        boolean attemptUpgrade;
        final ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{TrafficLoggingHandler.CLIENT});
        switch (this.httpPreference) {
            case HTTP1_REQUIRED: {
                attemptUpgrade = false;
                break;
            }
            case HTTP2_PREFERRED: {
                attemptUpgrade = !SessionProtocolNegotiationCache.isUnsupported(this.remoteAddress, SessionProtocol.H2C);
                break;
            }
            case HTTP2_REQUIRED: {
                attemptUpgrade = true;
                break;
            }
            default: {
                throw new Error();
            }
        }
        if (attemptUpgrade) {
            Http2ClientConnectionHandler http2Handler = this.newHttp2ConnectionHandler(ch);
            if (this.options.useHttp2Preface()) {
                pipeline.addLast(new ChannelHandler[]{new DowngradeHandler()});
                pipeline.addLast(new ChannelHandler[]{http2Handler});
            } else {
                Http1ClientCodec http1Codec = HttpClientPipelineConfigurator.newHttp1Codec();
                Http2ClientUpgradeCodec http2ClientUpgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)http2Handler);
                HttpClientUpgradeHandler http2UpgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)http1Codec, (HttpClientUpgradeHandler.UpgradeCodec)http2ClientUpgradeCodec, (int)Math.min(Integer.MAX_VALUE, 16384L));
                pipeline.addLast(new ChannelHandler[]{http1Codec});
                pipeline.addLast(new ChannelHandler[]{new WorkaroundHandler()});
                pipeline.addLast(new ChannelHandler[]{http2UpgradeHandler});
                pipeline.addLast(new ChannelHandler[]{new UpgradeRequestHandler(http2Handler.responseDecoder())});
            }
        } else {
            pipeline.addLast(new ChannelHandler[]{HttpClientPipelineConfigurator.newHttp1Codec()});
            pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    ctx.pipeline().remove((ChannelHandler)this);
                    HttpClientPipelineConfigurator.this.finishSuccessfully(pipeline, SessionProtocol.H1C);
                    ctx.fireChannelActive();
                }
            }});
        }
    }

    private void finishSuccessfully(ChannelPipeline pipeline, SessionProtocol protocol) {
        long idleTimeoutMillis;
        if (protocol == SessionProtocol.H1 || protocol == SessionProtocol.H1C) {
            this.addBeforeSessionHandler(pipeline, (ChannelHandler)new Http1ResponseDecoder(pipeline.channel()));
        }
        if ((idleTimeoutMillis = this.options.idleTimeoutMillis()) > 0L) {
            pipeline.addFirst(new ChannelHandler[]{new HttpClientIdleTimeoutHandler(idleTimeoutMillis)});
        }
        pipeline.channel().eventLoop().execute(() -> pipeline.fireUserEventTriggered((Object)protocol));
    }

    private void addBeforeSessionHandler(ChannelPipeline pipeline, ChannelHandler handler) {
        ChannelHandlerContext lastContext = pipeline.lastContext();
        if (lastContext.handler().getClass() != HttpSessionHandler.class) {
            throw new IllegalStateException();
        }
        pipeline.addBefore(lastContext.name(), null, handler);
    }

    private void finishWithNegotiationFailure(ChannelHandlerContext ctx, SessionProtocol expected, SessionProtocol actual, String reason) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.channel().eventLoop().execute(() -> pipeline.fireUserEventTriggered((Object)new SessionProtocolNegotiationException(expected, actual, reason)));
        ctx.close();
    }

    private boolean isHttp2Protocol(SslHandler sslHandler) {
        return "h2".equals(sslHandler.applicationProtocol());
    }

    private Http2ClientConnectionHandler newHttp2ConnectionHandler(Channel ch) {
        boolean validateHeaders = false;
        DefaultHttp2Connection conn = new DefaultHttp2Connection(false);
        conn.addListener((Http2Connection.Listener)new Http2GoAwayListener(ch));
        try (DefaultHttp2FrameReader reader = new DefaultHttp2FrameReader(false);){
            DefaultHttp2FrameWriter writer = new DefaultHttp2FrameWriter();
            DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder((Http2Connection)conn, (Http2FrameWriter)writer);
            DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder((Http2Connection)conn, (Http2ConnectionEncoder)encoder, (Http2FrameReader)reader);
            Http2ResponseDecoder listener = new Http2ResponseDecoder((Http2Connection)conn, ch);
            Http2ClientConnectionHandler handler = new Http2ClientConnectionHandler((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder, new Http2Settings(), listener);
            handler.gracefulShutdownTimeoutMillis(this.options.idleTimeoutMillis());
            Http2ClientConnectionHandler http2ClientConnectionHandler = handler;
            return http2ClientConnectionHandler;
        }
    }

    private static void retryWithH1C(ChannelHandlerContext ctx) {
        HttpSession.get(ctx.channel()).retryWithH1C();
        ctx.close();
    }

    private static Http1ClientCodec newHttp1Codec() {
        return new Http1ClientCodec(){

            public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                HttpSession.get(ctx.channel()).deactivate();
                super.close(ctx, promise);
            }
        };
    }

    private static final class WorkaroundHandler
    extends ChannelDuplexHandler {
        private static final AsciiString CONNECTION_VALUE = new AsciiString((CharSequence)"HTTP2-Settings,Upgrade");
        private boolean needsToFilterUpgradeResponse = true;
        private boolean needsToFilterUpgradeRequest = true;

        private WorkaroundHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (this.needsToFilterUpgradeResponse && msg instanceof HttpResponse) {
                HttpHeaders headers;
                this.needsToFilterUpgradeResponse = false;
                HttpResponse res = (HttpResponse)msg;
                if (res.status().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && !(headers = res.headers()).contains((CharSequence)HttpHeaderNames.UPGRADE)) {
                    headers.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
                }
                if (!this.needsToFilterUpgradeRequest) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
            ctx.fireChannelRead(msg);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (this.needsToFilterUpgradeRequest) {
                this.needsToFilterUpgradeRequest = false;
                FullHttpRequest req = (FullHttpRequest)msg;
                req.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)CONNECTION_VALUE);
                if (!this.needsToFilterUpgradeResponse) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
            super.write(ctx, msg, promise);
        }
    }

    private final class DowngradeHandler
    extends ByteToMessageDecoder {
        private boolean handledResponse;

        private DowngradeHandler() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() < 4) {
                return;
            }
            this.handledResponse = true;
            ChannelPipeline p = ctx.pipeline();
            if (in.getInt(in.readerIndex()) == 1213486160) {
                SessionProtocolNegotiationCache.setUnsupported(ctx.channel().remoteAddress(), SessionProtocol.H2C);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2C, SessionProtocol.H1C, "received an HTTP/1 response for the HTTP/2 preface string");
                } else {
                    HttpClientPipelineConfigurator.retryWithH1C(ctx);
                }
                in.skipBytes(in.readableBytes());
            } else {
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, SessionProtocol.H2C);
            }
            p.remove((ChannelHandler)this);
        }

        protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            super.decodeLast(ctx, in, out);
            if (!this.handledResponse) {
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2C, SessionProtocol.H1C, "too little data to determine the HTTP version");
                } else {
                    HttpClientPipelineConfigurator.retryWithH1C(ctx);
                }
            }
        }
    }

    private final class UpgradeRequestHandler
    extends ChannelInboundHandlerAdapter {
        private final Http2ResponseDecoder responseDecoder;
        private HttpClientUpgradeHandler.UpgradeEvent upgradeEvt;

        UpgradeRequestHandler(Http2ResponseDecoder responseDecoder) {
            this.responseDecoder = responseDecoder;
        }

        public void channelActive(final ChannelHandlerContext ctx) throws Exception {
            DefaultFullHttpRequest upgradeReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.HEAD, "/");
            String host = HttpHeaderUtil.hostHeader(HttpClientPipelineConfigurator.this.remoteAddress.getHostString(), HttpClientPipelineConfigurator.this.remoteAddress.getPort(), SessionProtocol.H1C.defaultPort());
            upgradeReq.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)host);
            upgradeReq.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)HttpHeaderUtil.USER_AGENT);
            ctx.writeAndFlush((Object)upgradeReq);
            Http2ResponseDecoder responseDecoder = this.responseDecoder;
            DecodedHttpResponse res = new DecodedHttpResponse(ctx.channel().eventLoop());
            res.init(responseDecoder.inboundTrafficController());
            res.subscribe((Subscriber<? super HttpObject>)new Subscriber<HttpObject>(){
                private boolean notified;

                public void onSubscribe(Subscription s) {
                    s.request(Long.MAX_VALUE);
                }

                public void onNext(HttpObject o) {
                    if (this.notified) {
                        return;
                    }
                    this.notified = true;
                    if (UpgradeRequestHandler.this.upgradeEvt != HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                        throw new IllegalStateException();
                    }
                    UpgradeRequestHandler.this.onUpgradeResponse(ctx, true, false);
                }

                public void onError(Throwable t) {
                    ctx.fireExceptionCaught(t);
                }

                public void onComplete() {
                }
            });
            responseDecoder.addResponse(0, null, res, RequestLogBuilder.NOOP, 0L, 16384L);
            ctx.fireChannelActive();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (!(evt instanceof HttpClientUpgradeHandler.UpgradeEvent)) {
                ctx.fireUserEventTriggered(evt);
                return;
            }
            HttpClientUpgradeHandler.UpgradeEvent upgradeEvt = (HttpClientUpgradeHandler.UpgradeEvent)evt;
            if (upgradeEvt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED) {
                return;
            }
            this.upgradeEvt = upgradeEvt;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof DefaultHttpResponse) {
                ReferenceCountUtil.release((Object)msg);
                if (this.upgradeEvt != HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
                    throw new IllegalStateException();
                }
                this.onUpgradeResponse(ctx, false, true);
                return;
            }
            ctx.fireChannelRead(msg);
        }

        private void onUpgradeResponse(ChannelHandlerContext ctx, boolean success, boolean close) {
            HttpClientUpgradeHandler.UpgradeEvent upgradeEvt = this.upgradeEvt;
            if (upgradeEvt == null) {
                throw new IllegalStateException();
            }
            ChannelPipeline p = ctx.pipeline();
            p.remove((ChannelHandler)this);
            if (close) {
                SessionProtocolNegotiationCache.setUnsupported(ctx.channel().remoteAddress(), SessionProtocol.H2C);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2C, SessionProtocol.H1C, "upgrade response with 'Connection: close' header");
                } else {
                    HttpClientPipelineConfigurator.retryWithH1C(ctx);
                }
                return;
            }
            if (success) {
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, SessionProtocol.H2C);
            } else {
                SessionProtocolNegotiationCache.setUnsupported(ctx.channel().remoteAddress(), SessionProtocol.H2C);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2C, SessionProtocol.H1C, "upgrade request rejected");
                    return;
                }
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, SessionProtocol.H1C);
            }
        }
    }

    private static enum HttpPreference {
        HTTP1_REQUIRED,
        HTTP2_PREFERRED,
        HTTP2_REQUIRED;

    }
}

