/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.helianthus.client.ResponseTimeoutException;
import org.xbib.helianthus.client.http.DecodedHttpResponse;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.common.http.HttpRequest;
import org.xbib.helianthus.common.http.HttpResponseWriter;
import org.xbib.helianthus.common.http.HttpStatus;
import org.xbib.helianthus.common.http.HttpStatusClass;
import org.xbib.helianthus.common.logging.RequestLogBuilder;
import org.xbib.helianthus.common.util.Exceptions;
import org.xbib.helianthus.internal.InboundTrafficController;

abstract class HttpResponseDecoder {
    private static final Logger logger = Logger.getLogger(HttpResponseDecoder.class.getName());
    private final IntObjectMap<HttpResponseWrapper> responses = new IntObjectHashMap();
    private final InboundTrafficController inboundTrafficController;
    private boolean disconnectWhenFinished;

    HttpResponseDecoder(Channel channel) {
        this.inboundTrafficController = new InboundTrafficController(channel);
    }

    final InboundTrafficController inboundTrafficController() {
        return this.inboundTrafficController;
    }

    final HttpResponseWrapper addResponse(int id, HttpRequest req, DecodedHttpResponse res, RequestLogBuilder logBuilder, long responseTimeoutMillis, long maxContentLength) {
        HttpResponseWrapper newRes = new HttpResponseWrapper(req, res, logBuilder, responseTimeoutMillis, maxContentLength);
        HttpResponseWriter oldRes = (HttpResponseWriter)this.responses.put(id, (Object)newRes);
        if (oldRes != null) {
            throw new IllegalStateException();
        }
        return newRes;
    }

    final HttpResponseWrapper getResponse(int id) {
        return (HttpResponseWrapper)this.responses.get(id);
    }

    final HttpResponseWrapper getResponse(int id, boolean remove) {
        return remove ? this.removeResponse(id) : this.getResponse(id);
    }

    final HttpResponseWrapper removeResponse(int id) {
        return (HttpResponseWrapper)this.responses.remove(id);
    }

    final boolean hasUnfinishedResponses() {
        return !this.responses.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void failUnfinishedResponses(Throwable cause) {
        try {
            for (HttpResponseWrapper res : this.responses.values()) {
                res.close(cause);
            }
        }
        finally {
            this.responses.clear();
        }
    }

    final void disconnectWhenFinished() {
        this.disconnectWhenFinished = true;
    }

    final boolean needsToDisconnect() {
        return this.disconnectWhenFinished && !this.hasUnfinishedResponses();
    }

    static final class HttpResponseWrapper
    implements HttpResponseWriter,
    Runnable {
        private final HttpRequest request;
        private final DecodedHttpResponse delegate;
        private final RequestLogBuilder logBuilder;
        private final long responseTimeoutMillis;
        private final long maxContentLength;
        private ScheduledFuture<?> responseTimeoutFuture;

        HttpResponseWrapper(HttpRequest request, DecodedHttpResponse delegate, RequestLogBuilder logBuilder, long responseTimeoutMillis, long maxContentLength) {
            this.request = request;
            this.delegate = delegate;
            this.logBuilder = logBuilder;
            this.responseTimeoutMillis = responseTimeoutMillis;
            this.maxContentLength = maxContentLength;
        }

        void scheduleTimeout(ChannelHandlerContext ctx) {
            if (this.responseTimeoutFuture != null || this.responseTimeoutMillis <= 0L || !this.isOpen()) {
                return;
            }
            this.responseTimeoutFuture = ctx.channel().eventLoop().schedule((Runnable)this, this.responseTimeoutMillis, TimeUnit.MILLISECONDS);
        }

        long maxContentLength() {
            return this.maxContentLength;
        }

        long writtenBytes() {
            return this.delegate.writtenBytes();
        }

        @Override
        public void run() {
            ResponseTimeoutException cause = ResponseTimeoutException.get();
            this.delegate.close((Throwable)((Object)cause));
            this.logBuilder.endResponse((Throwable)((Object)cause));
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public boolean write(HttpObject o) {
            if (o instanceof HttpHeaders) {
                this.logBuilder.startResponse();
                HttpHeaders headers = (HttpHeaders)o;
                HttpStatus status = headers.status();
                if (status != null && status.codeClass() != HttpStatusClass.INFORMATIONAL) {
                    this.logBuilder.statusCode(status.code());
                    this.logBuilder.requestEnvelope((Object)headers);
                }
            } else if (o instanceof HttpData) {
                this.logBuilder.increaseResponseLength((long)((HttpData)o).length());
            }
            return this.delegate.write(o);
        }

        public boolean write(Supplier<? extends HttpObject> o) {
            return this.delegate.write(o);
        }

        public CompletableFuture<Void> onDemand(Runnable task) {
            return this.delegate.onDemand(task);
        }

        public void close() {
            if (this.request != null) {
                this.request.abort();
            }
            if (this.cancelTimeout()) {
                this.delegate.close();
                this.logBuilder.endResponse();
            }
        }

        public void close(Throwable cause) {
            if (this.request != null) {
                this.request.abort();
            }
            if (this.cancelTimeout()) {
                this.delegate.close(cause);
                this.logBuilder.endResponse(cause);
            } else if (!Exceptions.isExpected((Throwable)cause)) {
                logger.log(Level.WARNING, "Unexpected exception:", cause);
            }
        }

        private boolean cancelTimeout() {
            ScheduledFuture<?> responseTimeoutFuture = this.responseTimeoutFuture;
            if (responseTimeoutFuture == null) {
                return true;
            }
            this.responseTimeoutFuture = null;
            return responseTimeoutFuture.cancel(false);
        }

        public void respond(HttpStatus status) {
            this.delegate.respond(status);
        }

        public void respond(HttpStatus status, String mediaType, String content) {
            this.delegate.respond(status, mediaType, content);
        }

        public void respond(HttpStatus status, String mediaType, String format, Object ... args) {
            this.delegate.respond(status, mediaType, format, args);
        }

        public void respond(HttpStatus status, String mediaType, byte[] content) {
            this.delegate.respond(status, mediaType, content);
        }

        public void respond(HttpStatus status, String mediaType, byte[] content, int offset, int length) {
            this.delegate.respond(status, mediaType, content, offset, length);
        }

        public String toString() {
            return ((Object)((Object)this.delegate)).toString();
        }
    }
}

