/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.pool;

import java.net.InetSocketAddress;
import java.util.Objects;
import org.xbib.helianthus.common.SessionProtocol;

public final class PoolKey {
    private final InetSocketAddress remoteAddress;
    private final SessionProtocol sessionProtocol;
    private final String value;

    public PoolKey(InetSocketAddress remoteAddress, SessionProtocol sessionProtocol) {
        this.remoteAddress = Objects.requireNonNull(remoteAddress, "remoteAddress");
        this.sessionProtocol = Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        this.value = sessionProtocol.uriText() + "://" + remoteAddress.getHostString() + ':' + remoteAddress.getPort();
    }

    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PoolKey)) {
            return false;
        }
        PoolKey poolKey = (PoolKey)o;
        return this.value.equals(poolKey.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "PoolKey[" + this.value + ']';
    }
}

