/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.pool;

import io.netty.channel.Channel;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.helianthus.client.pool.KeyedChannelPoolHandler;

class SafeKeyedChannelPoolHandler<K>
implements KeyedChannelPoolHandler<K> {
    private static final Logger logger = Logger.getLogger(SafeKeyedChannelPoolHandler.class.getName());
    private final KeyedChannelPoolHandler<K> handler;

    SafeKeyedChannelPoolHandler(KeyedChannelPoolHandler<K> handler) {
        this.handler = handler;
    }

    private static void logFailure(String handlerName, Throwable cause) {
        logger.log(Level.WARNING, MessageFormat.format("Exception handling {0}()", handlerName), cause);
    }

    @Override
    public void channelReleased(K key, Channel ch) {
        try {
            this.handler.channelReleased(key, ch);
        }
        catch (Exception e) {
            SafeKeyedChannelPoolHandler.logFailure("channelReleased", e);
        }
    }

    @Override
    public void channelAcquired(K key, Channel ch) {
        try {
            this.handler.channelAcquired(key, ch);
        }
        catch (Exception e) {
            SafeKeyedChannelPoolHandler.logFailure("channelAcquired", e);
        }
    }

    @Override
    public void channelCreated(K key, Channel ch) {
        try {
            this.handler.channelCreated(key, ch);
        }
        catch (Exception e) {
            SafeKeyedChannelPoolHandler.logFailure("channelCreated", e);
        }
    }

    @Override
    public void channelClosed(K key, Channel ch) {
        try {
            this.handler.channelClosed(key, ch);
        }
        catch (Exception e) {
            SafeKeyedChannelPoolHandler.logFailure("channelClosed", e);
        }
    }
}

