/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.routing;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class EndpointGroupUtil {
    private static final String ENDPOINT_GROUP_MARK = "group:";
    private static final Pattern ENDPOINT_GROUP_PATTERN = Pattern.compile("://(?:[^@]*@)?(group:([^:/]+)(:\\d+)?)");

    private EndpointGroupUtil() {
    }

    public static String getEndpointGroupName(URI uri) {
        return EndpointGroupUtil.getEndpointGroupName(uri.toString());
    }

    public static String getEndpointGroupName(String uri) {
        Matcher matcher = ENDPOINT_GROUP_PATTERN.matcher(uri);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    public static String replaceEndpointGroup(URI uri, String endpointUri) {
        return EndpointGroupUtil.replaceEndpointGroup(uri.toString(), endpointUri);
    }

    public static String replaceEndpointGroup(String uri, String endpointUri) {
        Matcher matcher = ENDPOINT_GROUP_PATTERN.matcher(uri);
        if (matcher.find()) {
            return new StringBuilder(uri).replace(matcher.start(1), matcher.end(1), endpointUri).toString();
        }
        return uri;
    }

    public static String removeGroupMark(URI uri) {
        return uri.toString().replaceFirst(ENDPOINT_GROUP_MARK, "");
    }
}

