package org.xbib.helianthus.client;

/**
 * A {@link RuntimeException} raised when the client received a response with an unexpected status code.
 */
public class InvalidResponseException extends RuntimeException {
    private static final long serialVersionUID = 7789160689214376205L;

    /**
     * Creates a new instance.
     */
    public InvalidResponseException() {
    }

    /**
     * Creates a new instance with the specified {@code message} and {@code cause}.
     */
    public InvalidResponseException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates a new instance with the specified {@code message}.
     */
    public InvalidResponseException(String message) {
        super(message);
    }

    /**
     * Creates a new instance with the specified {@code cause}.
     */
    public InvalidResponseException(Throwable cause) {
        super(cause);
    }

    /**
     * Creates a new instance with the specified {@code message}, {@code cause}, suppression enabled or
     * disabled, and writable stack trace enabled or disabled.
     */
    protected InvalidResponseException(String message, Throwable cause, boolean enableSuppression,
                                       boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }
}
