package org.xbib.helianthus.client.pool;

import io.netty.channel.Channel;

/**
 * Handles the events produced by {@link KeyedChannelPool}.
 */
public interface KeyedChannelPoolHandler<K> {

    /**
     * Invoked when the specified {@code channel} has been created for the specified {@code key}.
     */
    void channelCreated(K key, Channel ch) throws Exception;

    /**
     * Invoked when the specified {@code channel} has been acquired from the pool.
     */
    void channelAcquired(K key, Channel ch) throws Exception;

    /**
     * Invoked when the specified {@code channel} has been released to the pool.
     */
    void channelReleased(K key, Channel ch) throws Exception;

    /**
     * Invoked when the specified {@code channel} has been closed and removed from the pool.
     */
    void channelClosed(K key, Channel ch) throws Exception;
}
