package org.xbib.helianthus.client.routing;

import org.xbib.helianthus.client.Endpoint;

public interface EndpointSelector {
    /**
     * Return the {@link EndpointGroup} held by this selector.
     */
    EndpointGroup group();

    /**
     * Return the {@link EndpointSelectionStrategy} used by this selector to select endpoints.
     */
    EndpointSelectionStrategy strategy();

    /**
     * Return a selected endpoint.
     */
    Endpoint select();
}
