/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.xbib.helianthus.client.SessionOptions;
import org.xbib.helianthus.client.SessionProtocolNegotiationCache;
import org.xbib.helianthus.client.SessionProtocolNegotiationException;
import org.xbib.helianthus.client.http.HttpClientPipelineConfigurator;
import org.xbib.helianthus.client.http.HttpSessionHandler;
import org.xbib.helianthus.client.pool.PoolKey;
import org.xbib.helianthus.common.SessionProtocol;

class HttpSessionChannelFactory
implements Function<PoolKey, Future<Channel>> {
    private final Bootstrap baseBootstrap;
    private final EventLoop eventLoop;
    private final Map<SessionProtocol, Bootstrap> bootstrapMap;
    private final SessionOptions options;

    HttpSessionChannelFactory(Bootstrap bootstrap, SessionOptions options) {
        this.baseBootstrap = Objects.requireNonNull(bootstrap);
        this.eventLoop = (EventLoop)bootstrap.config().group();
        this.bootstrapMap = Collections.synchronizedMap(new EnumMap(SessionProtocol.class));
        this.options = options;
    }

    @Override
    public Future<Channel> apply(PoolKey key) {
        SessionProtocol protocol;
        InetSocketAddress remoteAddress = key.remoteAddress();
        if (SessionProtocolNegotiationCache.isUnsupported(remoteAddress, protocol = key.sessionProtocol())) {
            return this.eventLoop.newFailedFuture((Throwable)new SessionProtocolNegotiationException(protocol, "previously failed negotiation"));
        }
        Promise sessionPromise = this.eventLoop.newPromise();
        this.connect(remoteAddress, protocol, (Promise<Channel>)sessionPromise);
        return sessionPromise;
    }

    void connect(SocketAddress remoteAddress, SessionProtocol protocol, Promise<Channel> sessionPromise) {
        Bootstrap bootstrap = this.bootstrap(protocol);
        ChannelFuture connectFuture = bootstrap.connect(remoteAddress);
        connectFuture.addListener(future -> {
            if (future.isSuccess()) {
                this.initSession(protocol, (ChannelFuture)future, sessionPromise);
            } else {
                sessionPromise.setFailure(future.cause());
            }
        });
    }

    private Bootstrap bootstrap(SessionProtocol sessionProtocol) {
        return this.bootstrapMap.computeIfAbsent(sessionProtocol, sp -> {
            Bootstrap bs = this.baseBootstrap.clone();
            bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpClientPipelineConfigurator(sp, HttpSessionChannelFactory.this.options)});
                }
            });
            return bs;
        });
    }

    private void initSession(SessionProtocol protocol, ChannelFuture connectFuture, Promise<Channel> sessionPromise) {
        if (!connectFuture.isSuccess()) {
            throw new IllegalStateException();
        }
        Channel ch = connectFuture.channel();
        EventLoop eventLoop = ch.eventLoop();
        if (!eventLoop.inEventLoop()) {
            throw new IllegalStateException();
        }
        io.netty.util.concurrent.ScheduledFuture timeoutFuture = eventLoop.schedule(() -> {
            if (sessionPromise.tryFailure((Throwable)new SessionProtocolNegotiationException(protocol, "connection established, but session creation timed out: " + ch))) {
                ch.close();
            }
        }, this.options.connectTimeoutMillis(), TimeUnit.MILLISECONDS);
        ch.pipeline().addLast(new ChannelHandler[]{new HttpSessionHandler(this, ch, sessionPromise, (ScheduledFuture<?>)timeoutFuture)});
    }
}

