/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.routing;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.client.routing.EndpointGroup;
import org.xbib.helianthus.client.routing.EndpointSelectionStrategy;
import org.xbib.helianthus.client.routing.EndpointSelector;

final class WeightedRoundRobinStrategy
implements EndpointSelectionStrategy {
    WeightedRoundRobinStrategy() {
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new RoundRobinSelector(endpointGroup);
    }

    static final class RoundRobinSelector
    implements EndpointSelector {
        private final EndpointGroup endpointGroup;
        private final AtomicLong sequence = new AtomicLong();
        private int minWeight = Integer.MAX_VALUE;
        private int maxWeight = Integer.MIN_VALUE;
        private int sumWeight;

        RoundRobinSelector(EndpointGroup endpointGroup) {
            Objects.requireNonNull(endpointGroup, "endpointGroup");
            this.endpointGroup = endpointGroup;
            endpointGroup.endpoints().forEach(e -> {
                int weight = e.weight();
                this.minWeight = Math.min(this.minWeight, weight);
                this.maxWeight = Math.max(this.maxWeight, weight);
                this.sumWeight += weight;
            });
        }

        @Override
        public EndpointGroup group() {
            return this.endpointGroup;
        }

        @Override
        public EndpointSelectionStrategy strategy() {
            return EndpointSelectionStrategy.WEIGHTED_ROUND_ROBIN;
        }

        @Override
        public Endpoint select() {
            List<Endpoint> endpoints = this.endpointGroup.endpoints();
            long currentSequence = this.sequence.getAndIncrement();
            if (this.minWeight < this.maxWeight) {
                LinkedHashMap<Endpoint, AtomicInteger> endpointWeights = new LinkedHashMap<Endpoint, AtomicInteger>();
                for (Endpoint endpoint : endpoints) {
                    endpointWeights.put(endpoint, new AtomicInteger(endpoint.weight()));
                }
                int mod = (int)(currentSequence % (long)this.sumWeight);
                for (int i = 0; i < this.maxWeight; ++i) {
                    for (Map.Entry entry : ((HashMap)endpointWeights).entrySet()) {
                        AtomicInteger weight = (AtomicInteger)entry.getValue();
                        if (mod == 0 && weight.get() > 0) {
                            return (Endpoint)entry.getKey();
                        }
                        if (weight.get() <= 0) continue;
                        weight.decrementAndGet();
                        --mod;
                    }
                }
            }
            return endpoints.get((int)(currentSequence % (long)endpoints.size()));
        }
    }
}

